(function () {
    var Utils = {
        _err: null,
        _listeners: {},
        url: {},
        theme: {
            primary: {
                background:'#ff0000',color:'#fff',
                accent: {background:'#ff0000',color:'#fff'},
                hover: {background:'#ff0000',color:'#fff'}
            },
            secondary: {background:'#ff4500',color:'#fff'},
            body: {background:'#FFF',color:'#000'},
            colors: {
                lightpurple: '#a5a1dd', darkpurple: '#7068c7', purple: '#8984d2',
                lightblue: '#9bd5ff', darkblue: '#276cbf', blue: '#4c7cbd',
                lightred: '#fd7176', darkred: '#9a2c29',  red: '#df3b37',
                lightyellow: '#ffe897', darkyellow: '#fbcf67', yellow: '#ffd748',
                lightorange: '#ff915d', darkorange: '#f37336', orange: '#fb8e5b',
                lightgreen: '#baebab', darkgreen: '#39af3e', green: '#5dce62',
                lightgrey: '#b6ddf2', darkgrey: '#6e92a6', grey: '#bbbbbb'
            }
        },
        _ajax: function (defaultScriptId, requests, doneFunction, singleDoneFunction){
        },
        ajax: function(requests, doneFunction, singleDoneFunction) {
            if (!Array.isArray(requests)) {
                requests = [requests];
            }
            if (typeof singleDoneFunction === 'undefined' || singleDoneFunction === null) {
                singleDoneFunction = false;
            }
            if (typeof doneFunction === 'undefined' || doneFunction === null) {
                doneFunction = false;
            }

            var deferreds = [];
            var sent = [];
            var results = {};
            for (var index = 0; index < requests.length; index++) {
                var request = requests[index];
                var inject = {
                    _user: true,
                    _json: true,
                    time: (new Date()).getTime(),
                    ajaxRequest: true
                };
                if (request.hasOwnProperty('data') && Object.keys(request.data).length > 0) {
                    request.data = Object.assign(request.data, inject);
                } else {
                    request = Object.assign(request, inject);
                }
                var requestType = (request.hasOwnProperty('type') ? request.type : 'POST');
                var requestData = (request.hasOwnProperty('data') && Object.keys(request.data).length > 0 ? request.data : request);
                var payload = {
                    cache: false,
                    async: request.hasOwnProperty('async') ? request.async : true,
                    raw: request.hasOwnProperty('raw'),
                    type: requestType,
                    dataType: (request.hasOwnProperty('dataType') ? request.dataType : 'json'),
                    index: (request.hasOwnProperty('index') ? request.index : index),
                    contentType: (request.hasOwnProperty('contentType') ? request.contentType : "application/json; charset=utf-8"),
                    data: (requestType === 'POST' ? JSON.stringify(requestData) : requestData),
                    url: (request.hasOwnProperty('url')
                            ? request.url
                            : "/"
                    ),
                    complete: function (response) {
                        var json = {};
                        if ('responseJSON' in response) {
                            json = response.responseJSON;
                        } else if (this.raw) {
                            json['raw'] = response.responseText
                        } else {
                            // console.log(response.responseText);
                            json = JSON.parse(response.responseText.replace(/\\'/g, "'"))
                        }
                        if (Array.isArray(json)) {
                            json[0]['request'] = (typeof this.data === 'string' ? JSON.parse(this.data) : this.data);
                        } else {
                            json['request'] = (typeof this.data === 'string' ? JSON.parse(this.data) : this.data);
                        }
                        if (json.hasOwnProperty('error') && json.error
                            && typeof json.error === 'object' && json.error.hasOwnProperty('message')) {
                            json = {
                                success: false,
                                code: json.error.code,
                                error_message: json.error.message,
                                message: json.error.message
                            };
                        }
                        if (singleDoneFunction) {
                            json['index'] = this.index;
                            singleDoneFunction(json);
                        }
                        results[this.index] = json;
                    },
                    error: function (response) {

                    }
                };
                sent.push((request.hasOwnProperty('index') ? request.index : index));
                deferreds.push(jQuery.ajax(payload));
            }
            jQuery.when.apply(jQuery, deferreds).always(function() {
                if (doneFunction) {
                    var check = setInterval(function() {
                        var complete = 0;
                        for (var sentIndex=0; sentIndex < sent.length; sentIndex++) {
                            if (results.hasOwnProperty(sent[sentIndex])) {
                                complete++;
                            }
                        }
                        // for some reason this will return before its
                        // actually complete, so lets check them
                        if (complete === sent.length) {
                            clearInterval(check);
                            if (sent.length === 1) {
                                results = results[0];
                            }
                            doneFunction(results);
                        }
                    },100);
                }
            });

        },
        listen: function(name, functionAfter) {
            this._listeners[name] = {event: new CustomEvent(name), after: functionAfter};
            document.addEventListener(name, this._listeners[name].after);
        },
        trigger: function(name, remove) {
            if (typeof remove === typeof undefined || remove === null) {
                remove = true;
            }
            if (name in this._listeners) {
                document.dispatchEvent(this._listeners[name].event);
                if (remove) {
                    document.removeEventListener(name, this._listeners[name].after);
                    delete this._listeners[name];
                }
            } else {
                console.log('Event "' + name + '" does not have any listeners');
            }
        },
        cleanRequestArray: function(array, separator) {
            if (typeof separator === typeof undefined || separator === null){
                separator = ',';
            }
            if (typeof array === 'string') {
                array = array.split(separator);
            }
            // this is to remove any blank spaces that are brought over
            for(var numIndex=0; numIndex < array.length; numIndex++) {
                if (array[numIndex].trim() === '') {
                    array.splice(numIndex,1);
                }
            }
            return array;
        },
        urlParams: function () {
            var url = {};
            var string = window.location.search.substring(1);
            console.log('getUrl: '+string);
            // var string = '{"' + decodeURI(window.location.search.substring(1))
            //     .replace(/"/g, '\\"')
            //     .replace(/&/g, '","')
            //     .replace(/=/g,'":"') + '"}';
            var groups = string.split('&');
            for (var i=0; i<groups.length; i++) {
                var parts = groups[i].split('=');
                var key = decodeURI(parts.length > 1 ? parts[0] : groups[i]);
                url[key] = decodeURI(parts.length > 1 ? parts[1] : true);
            }
            return url;
        },
        parseFloat: function(string) {
            string = string.replace(/,/,'');
            return parseFloat(string);
        },
        parseInt: function(string) {
            string = string.replace(/,/,'');
            return parseInt(string,10);
        },
        number: function(number, decimals) {
            decimals = (typeof decimals === 'undefined' || decimals === null ? 0 : decimals);
            number = (isNaN(parseFloat(number)) ? 0 : number);
            return parseFloat(number).toFixed(decimals).replace(/\d(?=(\d{3})+\.)/g, '$&,');
        },
        money: function(number) {
            number = (isNaN(parseFloat(number)) ? 0 : number);
            return parseFloat(number).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
        },
        boolflip: function(bool) {
            return !bool;
        },
        tl_number: function (number, options) {
            if (typeof options === 'undefined' || options === null) {
                options = [];
            }
            return this.number(number, options.length === 1 ? options[0] : null);
        },
        tl_replace: function (string, options) {
            if (options.length !== 2) {
                throw {message:'replace requires 2 parameters'}
            }
            var flags = options[0].replace(/.*\/([gimy]*)$/, '$1');
            var pattern = options[0].replace(new RegExp('^/(.*?)/'+flags+'$'), '$1');
            if (flags !== pattern) {
                options[0] = new RegExp(pattern, flags);
            }
            if (options[1] === "''" || options[1] === '""') {
                options[1] = '';
            }
            return string.replace(options[0], options[1]);
        },
        /**
         * Grabs URL
         */
        _setUrl: function() {
            var string = window.location.search.substring(1);
            // var string = '{"' + decodeURI(window.location.search.substring(1))
            //     .replace(/"/g, '\\"')
            //     .replace(/&/g, '","')
            //     .replace(/=/g,'":"') + '"}';
            var groups = string.split('&');
            for (var i=0; i<groups.length; i++) {
                var parts = groups[i].split('=');
                var key = decodeURI(parts.length > 1 ? parts[0] : groups[i]);
                this.url[key] = decodeURI(parts.length > 1 ? parts[1] : true).replace(/%26/g, '&');
            }
        },
        getUrlParams: function() {
            if (Object.keys(this.url).length === 0) {
                this._setUrl();
            }
            return this.url;
        },
        setUrlParams: function(params) {
            var urls = [
                window.location.origin + window.location.pathname
            ];
            if (typeof params !== 'object') {
                params = {};
            }
            params = Object.assign(this.getUrlParams(), params);
            if (Object.keys(params).length > 0) {
                urls[0] = urls[0] + '?'
            }
            for (var field in params) {
                if (!params.hasOwnProperty(field)) { continue; }
                var value = params[field];
                value = encodeURI(value).replace(/&/g,'%26')
                urls.push(field + '=' + value);
            }
            var url = urls.splice(0,1)[0];
            console.log(url);
            console.log(urls);
            window.history.replaceState(null, null, url + urls.join('&'));
        },
        setThemeCss: function() {
            this._setThemeColors();
        },
        /**
         * Grabs theme color from the UI and sets variables
         */
        _setThemeColors: function() {
            var body = jQuery('body');
            var nav = jQuery('.navbar');
            var group = jQuery('.fgroup_title');
            var menuSelect = jQuery('.sidebar');
            if (menuSelect.length === 0) {
                body.append('<div id="ns_navigation" class="deleteme sidebar" style="display:none;"><div class="ns-menu"><div class="ns-menuitem ns-menuitem-selected"></div></div></div>');
                menuSelect = jQuery('.sidebar');
            }
            var menuHighlight = jQuery('.ns-menuitem.ns-active');
            if (menuHighlight.length === 0) {
                body.append('<div id="ns_navigation" class="deleteme" style="display:none;"><div class="ns-menu"><div class="ns-menuitem ns-active"></div></div></div>');
                menuHighlight = jQuery('.ns-menuitem.ns-active');
            }
            this.theme.primary.background = nav.css('background-color');
            this.theme.primary.color = nav.find('ul').css('color');
            this.theme.primary.accent.background = menuSelect.css('background-color');
            this.theme.primary.accent.color = nav.find('ul').css('color');
            this.theme.primary.hover.background = menuHighlight.css('background-color');
            this.theme.primary.hover.color = this.theme.primary.accent.background;
            if (nav.length === 0 ) {
                console.log('no nav, set default')
                this.theme.primary = { // Default theme
                    "background": "rgb(40, 117, 135)",
                    "color": "rgb(255, 255, 255)",
                    "accent": {
                        "background": "rgb(6, 54, 71)",
                        "color": "rgb(255, 255, 255)"
                    },
                    "hover": {
                        "background": "rgb(212, 227, 231)",
                        "color": "rgb(6, 54, 71)"
                    }
                }
            }
            // console.log(JSON.stringify(this.theme.primary))
            if (group.length > 0) {
                this.theme.secondary.background = this.theme.primary.hover.background;
                this.theme.secondary.color = group.css('color');
            } else {
                this.theme.secondary.background = this.theme.primary.background.replace('rgb','rgba').replace(')',',.5)');
                this.theme.secondary.color = this.theme.primary.color;
            }
            this.theme.body.background = body.css('background-color');
            this.theme.body.color = body.css('color');
            var suiteletTitle = jQuery('.pt_title');
            if (suiteletTitle.length > 0) {
                suiteletTitle.closest('.bgbar').css('background-color', this.theme.primary.background);
                suiteletTitle.css('padding','5px 10px')
            }
            jQuery('.deleteme').remove();
            var rootTheme = jQuery('style#root-theme')
            if (rootTheme.length === 0) {
                var cssContent = ":root{" +
                    "--primary-background:'@primary-background';--primary-color:'@primary-color';" +
                    "--primary-accent-background:'@primary-accent-background';--primary-accent-color:'@primary-accent-color';" +
                    "--primary-hover-background:'@primary-hover-background';--primary-hover-color:'@primary-hover-color';" +
                    "--secondary-background:'@secondary-background';--secondary-color:'@secondary-color';" +
                    "--body-background:'@body-background';--body-color:'@body-color';" +
                    "--color-blue:'@color-blue';--color-blue-light:'@color-blue-light';--color-blue-dark:'@color-blue-dark';" +
                    "--color-red:'@color-red';--color-red-light:'@color-red-light';--color-red-dark:'@color-red-dark';" +
                    "--color-yellow:'@color-yellow';--color-yellow-light:'@color-yellow-light';--color-yellow-dark:'@color-yellow-dark';" +
                    "--color-orange:'@color-orange';--color-orange-light:'@color-orange-light';--color-orange-dark:'@color-orange-dark';" +
                    "--color-green:'@color-green';--color-green-light:'@color-green-light';--color-green-dark:'@color-green-dark';" +
                    "--color-purple:'@color-purple';--color-purple-light:'@color-purple-light';--color-purple-dark:'@color-purple-dark';" +
                    "--color-grey:'@color-grey';--color-grey-light:'@color-grey-light';--color-grey-dark:'@color-grey-dark';" +
                    "}";
                cssContent = cssContent.replace("'@primary-background'", utils.theme.primary.background);
                cssContent = cssContent.replace("'@primary-color'", utils.theme.primary.color);
                cssContent = cssContent.replace("'@primary-accent-background'", utils.theme.primary.accent.background);
                cssContent = cssContent.replace("'@primary-accent-color'", utils.theme.primary.accent.color);
                cssContent = cssContent.replace("'@primary-hover-background'", utils.theme.primary.hover.background);
                cssContent = cssContent.replace("'@primary-hover-color'", utils.theme.primary.hover.color);
                cssContent = cssContent.replace("'@secondary-background'", utils.theme.secondary.background);
                cssContent = cssContent.replace("'@secondary-color'", utils.theme.secondary.color);
                cssContent = cssContent.replace("'@body-background'", utils.theme.body.background);
                cssContent = cssContent.replace("'@body-color'", utils.theme.body.color);
                cssContent = cssContent.replace("'@color-blue'", utils.theme.colors.blue);
                cssContent = cssContent.replace("'@color-blue-light'", utils.theme.colors.lightblue);
                cssContent = cssContent.replace("'@color-blue-dark'", utils.theme.colors.darkblue);
                cssContent = cssContent.replace("'@color-red'", utils.theme.colors.red);
                cssContent = cssContent.replace("'@color-red-light'", utils.theme.colors.lightred);
                cssContent = cssContent.replace("'@color-red-dark'", utils.theme.colors.darkred);
                cssContent = cssContent.replace("'@color-yellow'", utils.theme.colors.yellow);
                cssContent = cssContent.replace("'@color-yellow-light'", utils.theme.colors.lightyellow);
                cssContent = cssContent.replace("'@color-yellow-dark'", utils.theme.colors.darkyellow);
                cssContent = cssContent.replace("'@color-orange'", utils.theme.colors.orange);
                cssContent = cssContent.replace("'@color-orange-light'", utils.theme.colors.lightorange);
                cssContent = cssContent.replace("'@color-orange-dark'", utils.theme.colors.darkorange);
                cssContent = cssContent.replace("'@color-green'", utils.theme.colors.green);
                cssContent = cssContent.replace("'@color-green-light'", utils.theme.colors.lightgreen);
                cssContent = cssContent.replace("'@color-green-dark'", utils.theme.colors.darkgreen);
                cssContent = cssContent.replace("'@color-purple'", utils.theme.colors.purple);
                cssContent = cssContent.replace("'@color-purple-light'", utils.theme.colors.lightpurple);
                cssContent = cssContent.replace("'@color-purple-dark'", utils.theme.colors.darkpurple);
                cssContent = cssContent.replace("'@color-grey'", utils.theme.colors.grey);
                cssContent = cssContent.replace("'@color-grey-light'", utils.theme.colors.lightgrey);
                cssContent = cssContent.replace("'@color-grey-dark'", utils.theme.colors.darkgrey);
                jQuery('<style>')
                    .attr('type', 'text/css')
                    .attr('id', 'root-theme')
                    .text(cssContent)
                    .appendTo('head');
            }
        },
        loadingIcon: function(size) {
            this.setThemeCss();
            if (typeof size === 'undefined' || size === null) {
                size = 64;
            }
            var box = (size/4) + size;
            var border = (size/8);
            var icon = jQuery('style#loading-icon')
            if (icon.length === 0) {
                jQuery('<style>')
                    .attr('type', 'text/css')
                    .attr('id', 'loading-icon')
                    .text('.ns-loading-ring{display:block;margin:auto;margin-bottom:50px;margin-top:50px;position:relative;width:' + box + 'px;height:' + box + 'px}.ns-loading-ring div{box-sizing:border-box;display:block;position:absolute;width:' + size + 'px;height:' + size + 'px;margin:' + border + 'px;border:' + border + 'px solid var(--primary-background);border-radius:50%;animation:lds-ring 1.2s cubic-bezier(.5,0,.25,1) infinite;border-color:var(--primary-background) transparent transparent transparent}.ns-loading-ring div:nth-child(1){animation-delay:-.25s}.ns-loading-ring div:nth-child(2){animation-delay:-.15s}.ns-loading-ring div:nth-child(3){animation-delay:-50ms}@keyframes lds-ring{0%{transform:rotate(0)}100%{transform:rotate(360deg)}}')
                    .appendTo('head');
            }
            return '<div class="ns-loading-ring"><div></div><div></div><div></div><div></div></div>';
        },
        line: function() {
            if (this._err) {
                var myCustomError = this._err.create({
                    name: 'MY_ERROR_CODE',
                    message: 'My custom error details',
                    notifyOff: true
                });
                var errorLine = myCustomError.stack[(myCustomError.stack.length - 1)].replace('at test (','').replace(')','').trim()
                return errorLine;
            } else {
                try {
                    new Error('');
                } catch(err) {
                    log.debug('err',JSON.stringify(err.lineNumber));
                    var caller_line = err.stack.split("\n")[4];
                    var index = caller_line.indexOf("at ");
                    var clean = caller_line.slice(index+2, caller_line.length);
                    return clean;
                }
            }
        },
        object: {
            keys: function(object) {
                var result = [];
                for (var key in object) {
                    if (!object.hasOwnProperty(key)) {continue;}
                    result.push(key);
                }
                return result;
            },
            values: function (object) {
                var result = [];
                for (var key in object) {
                    if (!object.hasOwnProperty(key)) {continue;}
                    result.push(object[key]);
                }
                return result;
            }
        },
        ip: {
            isValid: function(ip) {
                if(typeof ip !== 'string') return false; // only do strings
                return ip.match(/\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/);
            },
            repeat: function (str,times) {
                var result = '';
                for (var index = 0; index < parseInt(times,10); index++) {
                    result += str;
                }
                return result;
            },
            isInRanges: function(ip, ranges, rangeSplit) {
                if (!Array.isArray(ranges)) {
                    if (typeof rangeSplit !== 'undefined' && rangeSplit !== null && ranges.indexOf(rangeSplit) >= 0) {
                        ranges = this._split(ranges, rangeSplit);
                    } else {
                        ranges = [ranges];
                    }
                }
                for (var index = 0; index < ranges.length; index++) {
                    if (this._isIpEqualOrInRange(ip, ranges[index])) {
                        return true;
                    }
                }
                return false;
            },
            toLong: function(ip) {
                if(!this.isValid(ip)) return false; // invalid IP address
                var parts = ip.match(/^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})$/);
                return parts ? parts[1] * 16777216 + parts[2] * 65536 + parts[3] * 256 + parts[4] * 1 : false;
            },
            longToIp: function(long) {
                return [long >>> 24, long >>> 16 & 0xFF, long >>> 8 & 0xFF, long & 0xFF].join('.');
            },
            _isIpEqualOrInRange: function(ip, target) {
                var range = this._getCidrRange(target);
                var start = this.toLong(range[0]);
                var end = this.toLong(range[1]);
                var long = this.toLong(ip);
                return (start <= long && long <= end);
            },
            _getCidrRange: function(cidr) {
                var part = cidr.split("/"); // part[0] = base address, part[1] = netmask
                if (part.length === 1) {
                    return [part[0], part[0]]
                }
                var ipaddress = part[0].split('.');
                var netmaskblocks = ["0","0","0","0"];
                if(!/\d+\.\d+\.\d+\.\d+/.test(part[1])) {
                    // part[1] has to be between 0 and 32
                    netmaskblocks = (this.repeat("1",(parseInt(part[1], 10))) + this.repeat("0",(32-parseInt(part[1], 10)))).match(/.{1,8}/g);
                    netmaskblocks = netmaskblocks.map(function(el) { return parseInt(el, 2); });
                } else {
                    // xxx.xxx.xxx.xxx
                    netmaskblocks = part[1].split('.').map(function(el) { return parseInt(el, 10) });
                }
                var invertedNetmaskblocks = netmaskblocks.map(function(el) { return el ^ 255; });
                var baseAddress = ipaddress.map(function(block, idx) { return block & netmaskblocks[idx]; });
                var broadcastaddress = ipaddress.map(function(block, idx) { return block | invertedNetmaskblocks[idx]; });
                return [baseAddress.join('.'), broadcastaddress.join('.')];
            },
            _split: function(string, splitter, clean) {
                if (typeof splitter === 'undefined' || splitter === null) {
                    splitter = "\n";
                }
                if (typeof clean === "undefined" || clean === null) {
                    clean = /[\n\r]/g;
                }
                var parts = string.split(splitter);
                var results = [];
                for (var index = 0; index < parts.length; index++) {
                    results.push(parts[index].replace(clean,"").trim());
                }
                return results
            }
        },
        base64: {
            _keyStr: 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=',
            isEncrypted: function(input) {
                return this.encrypt(this.decrypt(input)) === input
            },
            encrypt: function(input) {
                var output = "";
                var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
                var i = 0;
                input = this._utf8_encode(input);
                while (i < input.length) {
                    chr1 = input.charCodeAt(i++);
                    chr2 = input.charCodeAt(i++);
                    chr3 = input.charCodeAt(i++);
                    enc1 = chr1 >> 2;
                    enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
                    enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
                    enc4 = chr3 & 63;
                    if (isNaN(chr2)) {
                        enc3 = enc4 = 64;
                    } else if (isNaN(chr3)) {
                        enc4 = 64;
                    }
                    output = output + this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) + this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);
                }
                return output;
            },
            decrypt: function(input) {
                var output = "";
                var chr1, chr2, chr3;
                var enc1, enc2, enc3, enc4;
                var i = 0;
                input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
                while (i < input.length) {
                    enc1 = this._keyStr.indexOf(input.charAt(i++));
                    enc2 = this._keyStr.indexOf(input.charAt(i++));
                    enc3 = this._keyStr.indexOf(input.charAt(i++));
                    enc4 = this._keyStr.indexOf(input.charAt(i++));
                    chr1 = (enc1 << 2) | (enc2 >> 4);
                    chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                    chr3 = ((enc3 & 3) << 6) | enc4;
                    output = output + String.fromCharCode(chr1);
                    if (enc3 !== 64) {
                        output = output + String.fromCharCode(chr2);
                    }
                    if (enc4 !== 64) {
                        output = output + String.fromCharCode(chr3);
                    }
                }
                output = this._utf8_decode(output);
                return output;
            },
            image: function(selector, complete) {
                if (typeof selector === 'string') {
                    if (selector.indexOf('#') >= 0 || selector.indexOf('.') >= 0) {
                        selector = jQuery(selector);
                    }
                    if (selector.indexOf('#') < 0 && selector.indexOf('.') < 0) {
                        selector = jQuery('#'+selector);
                    }
                }
                if (typeof selector === 'object' && selector.length === 0) {
                    alert("Having trouble finding the selector for image base64")
                    return false;
                }
                var filesSelected = selector.prop('files');
                if (filesSelected.length > 0) {
                    var fileToLoad = filesSelected[0];
                    console.log("Loading...")
                    var fileReader = new FileReader();
                    fileReader.onload = function(fileLoadedEvent) {
                        console.log("Loading... Done")
                        var srcData = fileLoadedEvent.target.result; // <--- data: base64
                        console.log("src " + srcData.substring(0,100)+" ...")
                        complete(srcData);
                    }
                    fileReader.readAsDataURL(fileToLoad);
                } else {
                    complete('');
                }
            },
            _utf8_encode: function(string) {
                string = string.replace(/\r\n/g, "\n");
                var utftext = "";

                for (var n = 0; n < string.length; n++) {
                    var c = string.charCodeAt(n);
                    if (c < 128) {
                        utftext += String.fromCharCode(c);
                    } else if ((c > 127) && (c < 2048)) {
                        utftext += String.fromCharCode((c >> 6) | 192);
                        utftext += String.fromCharCode((c & 63) | 128);
                    } else {
                        utftext += String.fromCharCode((c >> 12) | 224);
                        utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                        utftext += String.fromCharCode((c & 63) | 128);
                    }
                }
                return utftext;
            },
            _utf8_decode: function(utftext) {
                var string = "";
                var i = 0;
                var c = c1 = c2 = 0;

                while (i < utftext.length) {
                    c = utftext.charCodeAt(i);
                    if (c < 128) {
                        string += String.fromCharCode(c);
                        i++;
                    } else if ((c > 191) && (c < 224)) {
                        c2 = utftext.charCodeAt(i + 1);
                        string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                        i += 2;
                    } else {
                        c2 = utftext.charCodeAt(i + 1);
                        c3 = utftext.charCodeAt(i + 2);
                        string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                        i += 3;
                    }
                }
                return string;
            }
        },
        timer: function(label) {
            var time = {
                _startTime: 0,
                _currentTime: 0,
                _label: '',
                time: function() {
                    return Math.floor(Date.now() / 1000);
                },
                start: function(label) {
                    this._label = label;
                    this._startTime = this.time();
                    this._currentTime = this._startTime;
                    log.debug('Time ' + this._label, 'Starting Timer')
                },
                stop: function() {
                    log.debug('Time ' + this._label, 'Stop, total time: ' + (this.time() - this._startTime));
                    this._currentTime = 0;
                    this._startTime = 0;
                },
                log: function(label) {
                    var time = this.time();
                    if (this._currentTime === 0) {
                        this._currentTime = time;
                        log.debug('Time' + this._label, 'Starting Timer')
                    } else {
                        log.debug('Time ' + this._label, label + ': ' + (time - this._currentTime));
                        this._currentTime = time;
                    }
                }
            };
            if (typeof label !== typeof undefined && label !== null) {
                time.start(label);
            }
            return time;
        },
        timestamp: function() {
            if (!Date.now) {
                Date.now = function() { return new Date().getTime(); }
            }
            return Date.now();
        },
        required: function (required, request) {
            if (typeof required === 'string') {
                required = [required];
            }
            var missing = [];
            for (var index = 0; index < required.length; index++) {
                var field = required[index];
                if (!(field in request) || (field in request && ((Array.isArray(request[field]) && request[field].length === 0) || request[field] === null || (typeof request[field] === "string" && request[field].trim() === '')))) {
                    missing.push(required[index]);
                }
            }
            return missing;
        },
        uuidv4: function() {
            var d = new Date().getTime();//Timestamp
            var d2 = (typeof performance !== 'undefined' && performance.now && (performance.now()*1000)) || 0;//Time in microseconds since page-load or 0 if unsupported
            return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
                var r = Math.random() * 16;//random number between 0 and 16
                if(d > 0){//Use timestamp until depleted
                    r = (d + r)%16 | 0;
                    d = Math.floor(d/16);
                } else {//Use microseconds since page-load if supported
                    r = (d2 + r)%16 | 0;
                    d2 = Math.floor(d2/16);
                }
                return (c === 'x' ? r : (r & 0x3 | 0x8)).toString(16);
            });
        },
        htmlEntities: function(str) {
            return String(str).replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;');
        },
        csvValue: function(str) {
            return this.csv._value(str);
        },
        arrayToCsv: function(array, header) {
            return this.csv.stringify(array, header);
        },
        csv: {
            _value: function(str) {
                str = str+"".replace(/"/g, '""');
                if (str === 'null') {
                    str = '';
                }
                return '"'+str+'"';
            },
            parse: function(strData, strDelimiter, header) {
                // Check to see if the delimiter is defined. If not,
                // then default to comma.
                strDelimiter = (strDelimiter || ",");
                header = (header || false);

                // Create a regular expression to parse the CSV values.
                var objPattern = new RegExp(
                    (
                        // Delimiters.
                        "(\\" + strDelimiter + "|\\r?\\n|\\r|^)" +

                        // Quoted fields.
                        "(?:\"([^\"]*(?:\"\"[^\"]*)*)\"|" +

                        // Standard fields.
                        "([^\"\\" + strDelimiter + "\\r\\n]*))"
                    ),
                    "gi"
                );


                // Create an array to hold our data. Give the array
                // a default empty first row.
                var arrData = [[]];

                // Create an array to hold our individual pattern
                // matching groups.
                var arrMatches = null;


                // Keep looping over the regular expression matches
                // until we can no longer find a match.
                while (arrMatches = objPattern.exec( strData )){

                    // Get the delimiter that was found.
                    var strMatchedDelimiter = arrMatches[ 1 ];

                    // Check to see if the given delimiter has a length
                    // (is not the start of string) and if it matches
                    // field delimiter. If id does not, then we know
                    // that this delimiter is a row delimiter.
                    if (
                        strMatchedDelimiter.length &&
                        strMatchedDelimiter !== strDelimiter
                    ){

                        // Since we have reached a new row of data,
                        // add an empty row to our data array.
                        arrData.push( [] );

                    }

                    var strMatchedValue;

                    // Now that we have our delimiter out of the way,
                    // let's check to see which kind of value we
                    // captured (quoted or unquoted).
                    if (arrMatches[ 2 ]){

                        // We found a quoted value. When we capture
                        // this value, unescape any double quotes.
                        strMatchedValue = arrMatches[ 2 ].replace(
                            new RegExp( "\"\"", "g" ),
                            "\""
                        );

                    } else {

                        // We found a non-quoted value.
                        strMatchedValue = arrMatches[ 3 ];

                    }


                    // Now that we have our value string, let's add
                    // it to the data array.
                    arrData[ arrData.length - 1 ].push( strMatchedValue );
                }

                // Return the parsed data.
                var arrayData = ( arrData )
                if (header) {
                    var rows = [];
                    var headers = arrayData[0];
                    for (var index = 1; index < arrayData.length; index++) {
                        var row = {};
                        for (var headerIndex = 0; headerIndex < headers.length; headerIndex++) {
                            row[headers[headerIndex]] = arrayData[index][headerIndex];
                        }
                        rows.push(row);
                    }
                    arrayData = rows;
                }
                return arrayData;
            },
            stringify: function(array, header) {
                if (typeof header === 'undefined') {
                    header = false;
                }
                var csv = '';
                if (header) {
                    var headers = Object.keys(array[0]);
                    var columns = [];
                    for (var index = 0; index < headers.length; index++) {
                        columns.push(this._value(headers[index]));
                    }
                    csv += columns.join(',') + "\n";
                }
                for (var index = 0; index < array.length; index++) {
                    var fields = Object.keys(array[index]);
                    var columns = [];
                    for (var fieldIndex = 0; fieldIndex < fields.length; fieldIndex++) {
                        columns.push(this._value(array[index][fields[fieldIndex]]));
                    }
                    csv += columns.join(',') + "\n";
                }
                return csv;
            }
        },
        isInt: function(value) {
            var x;
            if (isNaN(value)) {
                return false;
            }
            x = parseFloat(value);
            return (x | 0) === x;
        },
        clone: function(value) {
            return JSON.parse(JSON.stringify(value));
        },
        jsonPretty: function(json) {
            /*
            pre {outline: 1px solid #ccc; padding: 5px; margin: 5px; }
            .string { color: green; }
            .number { color: darkorange; }
            .boolean { color: blue; }
            .null { color: magenta; }
            .key { color: red; }
             */
            var color = {
                string: this.theme.colors.darkorange,
                number: this.theme.colors.darkgreen,
                boolean: this.theme.colors.darkgreen,
                null: this.theme.colors.darkgrey,
                key: this.theme.colors.blue
            };
            if (typeof json != 'string') {
                json = JSON.stringify(json, undefined, 2);
            }
            json = json.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
            return '<pre style="white-space: pre-wrap; outline: 1px solid '+this.theme.primary.background+'; padding: 5px; margin: 5px;">' + json.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g, function (match) {
                var cls = 'number';
                if (/^"/.test(match)) {
                    if (/:$/.test(match)) {
                        cls = 'key';
                    } else {
                        cls = 'string';
                    }
                } else if (/true|false/.test(match)) {
                    cls = 'boolean';
                } else if (/null/.test(match)) {
                    cls = 'null';
                }
                return '<span class="' + cls + '" style="color: ' + color[cls] + ';">' + match + '</span>';
            }) + '</pre>';
        },
        upperCaseFirst: function(string) {
            if (typeof string !== 'string') return ''
            string = string.toLowerCase();
            return string.charAt(0).toUpperCase() + string.slice(1)
        },
        upperCaseWords: function(string) {
            var words = string.split(' ');
            for (var index = 0; index < words.length; index++) {
                words[index] = this.upperCaseFirst(words[index]);
            }
            return words.join(' ');
        },
        toUpperCase: function(string) {
            return string.toUpperCase();
        },
        timeout: function (callback, milliseconds) {
            var start = new Date().getTime();
            for (var i = 0; i < 1e7; i++) {
                if ((new Date().getTime() - start) > milliseconds) {
                    return callback();
                }
            }
            return false;
        },
        interval: function(callback, milliseconds) {
            var working = true;
            while(working) {
                var result = this.timeout(callback, milliseconds);
                if (typeof result !== 'undefined' && result !== false && result !== null) {
                    working = false;
                }
            }
            return result;
        },
        typewatch: (function(){
            var timer = 0;
            return function(callback, ms){
                clearTimeout (timer);
                timer = setTimeout(callback, ms);
            }
        })(),
        percentile: function(arr, p) {
            if (arr.length === 0) return 0;
            if (typeof p !== 'number') { throw {message:'p must be a number'}; }
            if (p <= 0) return arr[0];
            if (p >= 1) return arr[arr.length - 1];

            var index = (arr.length - 1) * p,
                lower = Math.floor(index),
                upper = lower + 1,
                weight = index % 1;

            if (upper >= arr.length) return arr[lower];
            return arr[lower] * (1 - weight) + arr[upper] * weight;
        },
        percentRank: function(arr, v) {
            if (typeof v !== 'number') { throw {message:'v must be a number'}; }
            for (var i = 0, l = arr.length; i < l; i++) {
                if (v <= arr[i]) {
                    while (i < l && v === arr[i]) i++;
                    if (i === 0) return 0;
                    if (v !== arr[i-1]) {
                        i += (v - arr[i-1]) / (arr[i] - arr[i-1]);
                    }
                    return i / l;
                }
            }
            return 1;
        },
        loadHTML: function(file, files) {
            var html = '';
            for (var index = 0; index < files.length; index++) {
                var type = (files[index].indexOf('.css') < 0 ? 'script' : 'style');
                var nameParts = files[index].split('/');
                var name = nameParts[(nameParts.length - 1)].replace('.','-');
                html += '\n\n<'+type+' id="'+name+'">\n';
                var fileObject = file.load({
                    id: files[index]
                });
                // var contents = fileObject.getContents().replace(/@/g,'-');
                var contents = fileObject.getContents();
                html += contents;
                html += '\n</'+type+'>';
            }
            return html;
        },
        file: {
            download: function(filename, contents, type) {
                if (typeof type === 'undefined' || type === null) {
                    type = 'text/plain;charset=utf-8;'
                }
                var blob = new Blob([contents], { type: type });
                if (navigator.msSaveBlob) { // IE 10+
                    navigator.msSaveBlob(blob, filename);
                } else {
                    var link = document.createElement("a");
                    if (link.download !== undefined) { // feature detection
                        // Browsers that support HTML5 download attribute
                        var url = URL.createObjectURL(blob);
                        link.setAttribute("href", url);
                        link.setAttribute("download", filename);
                        link.style.visibility = 'hidden';
                        document.body.appendChild(link);
                        link.click();
                        document.body.removeChild(link);
                    }
                }
            }
        }
    };

    if (typeof define === 'function') {
        define(['N/error'],
            function(error) {
                Utils._err = error;
                return Utils;
            });
    } else {
        window.utils = Utils;
    }
})();