<?php
namespace BK;

class Curzzler  {
    public $timeout = 600;
    public $debug = false;
    public $header;
    public $request = [
        'method' => '',
        'url' => '',
        'header' => [],
        'params' => []
    ];
    public $requestInBody = false;

    function __construct() {
    }

    public function populateHeaders($request) {
        return $request;
    }

    public function call($request) {
        $result = $this->multi([$request]);
        return $result[array_keys($result)[0]];
    }


    public function multi($requests) {
        set_time_limit($this->timeout);
        $curl_array = array();
        $ch = curl_multi_init();
        $header = ["User-Agent: Mozilla/5.0 (X11; Linux i686; rv:20.0) Gecko/20121230 Firefox/20.0"];
        foreach($requests as $count => $request) {
            if (!isset($request['method'])) {
                $request['method'] = 'GET';
            }
            $request['method'] = strtoupper($request['method']);
            if ($request['method'] == 'POST' && !isset($request['requestInBody'])) {
                $request['requestInBody'] = true;
            }
            if (!isset($request['requestInBody'])) {
                $request['requestInBody'] = $this->requestInBody;
            }
            if (!$request['requestInBody']) {
                $urlParts = parse_url($request['url']);
                if (isset($urlParts['query'])) {
                    parse_str($urlParts['query'], $query);
                } else { $query = []; }
                if (isset($request['params']) && is_array($request['params'])) {
                    $query = array_merge($query, $request['params']);
                    $request['url'] = "{$urlParts['scheme']}://{$urlParts['host']}{$urlParts['path']}?" . http_build_query($query);
                }
            }
            $body = null;
            $request = $this->populateHeaders($request);
            $curl_array[$count] = curl_init($request['url']);
            if (isset($request['header']) && !empty($request['header'])) {
                foreach ($request['header'] as $key => $value) {
                    $header[] = (is_numeric($key) ? $value : "{$key}: {$value}");
                }
            }
            if (!in_array($request['method'], ['GET','POST'])) {
                curl_setopt($curl_array[$count], CURLOPT_CUSTOMREQUEST, strtoupper($request['method']));
            }
            if ($request['requestInBody']) {
                curl_setopt($curl_array[$count], CURLOPT_POST, 1);
                if (isset($request['body'])) {
                    $body = $request['body'];
                } else {
                    $body = json_encode($request['params']);
                    if (json_last_error() != JSON_ERROR_NONE) {
                        throw new \Exception("Unable to encode: " . print_r($request['params'], true));
                    }
                    $header[] = 'Content-Length: ' . strlen($body);
                }
                curl_setopt($curl_array[$count], CURLOPT_POSTFIELDS, $body);
            }
            if ($this->debug) {
                echo "<pre>";
                print_r($request);
                print_r($header);
                print_r($body);
                curl_setopt($curl_array[$count], CURLOPT_VERBOSE, true);
            }
            curl_setopt($curl_array[$count], CURLOPT_HTTPHEADER, $header);
            curl_setopt($curl_array[$count], CURLOPT_TIMEOUT, $this->timeout);
            curl_setopt($curl_array[$count], CURLOPT_FOLLOWLOCATION, 1);
            curl_setopt($curl_array[$count], CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($curl_array[$count], CURLOPT_HEADER, 1);
            curl_multi_add_handle($ch, $curl_array[$count]);
        }

        do {
            curl_multi_exec($ch, $exec);
        } while($exec > 0);

        $return = [];
        foreach($requests as $count => $url) {
            $returned = curl_multi_getcontent($curl_array[$count]);
            $info = curl_getinfo($curl_array[$count]);
            $response = [
                'returned' => $returned,
                'header' => substr($returned, 0, $info['header_size']),
                'body' => substr($returned, $info['header_size']),
                'info' => $info
            ];
            $content = $info['content_type'];
            if (stripos($content,'application/json') !== false) {
                $content = 'application/json';
            }
            switch ($content) {
                case 'application/json':
                case 'json':
                    $response['data'] = json_decode($response['body'], true);
                    break;
                default:
                    $response['data'] = $response['body'];
                    break;
            }
            if ($this->debug) {
                print_r($response);
            }
            $return[$count] = $response;
        }

        curl_multi_close($ch);
        foreach($requests as $count => $url) {
            curl_close($curl_array[$count]);
        }
        return $return;
    }
}