<?php

namespace BK;

use BK\REST\Netsuite;
use Slim\Container;

class Handler {
    public $sandboxAppend = '';
    /**
     * @var \Monolog\Logger
     */
    public $log;
    /**
     * @var Container
     */
    public $app;

    /**
     * @var Netsuite
     */
    public $ns;

    /**
     * Handler constructor.
     * @param Container $app
     */
    function __construct($app) {
        $this->app = $app;
    }

    /**
     * @param \Monolog\Logger $log
     */
    public function setLog($log) {
        $this->log = $log;
    }

    public function newLog($name) {
        $logger = new \Monolog\Logger($name);
        $base = str_replace(['/src','/classes','/BK','/Route'],'',__DIR__);
        $file_handler = new \Monolog\Handler\StreamHandler($base . '/logs/'.$name.'-'. date('Y-m-d') . '.log');
        $logger->pushHandler($file_handler);
        $this->log = $logger;
        return $logger;
    }

    public function getEnvName($name) {
        return $name . ($this->app->_env == 'development' ? $this->sandboxAppend : '');
    }

    public function authenticateWithNetsuite() {
        $this->ns = new Netsuite($this->app->settings['file']['rest'][$this->getEnvName('netsuite')]);
    }

}