<?php

namespace BK\PDO;
use BK\PDO\Query;

class MySQL extends Query {
    public $dns;
    function __construct(\PDO $connection) {
        parent::__construct($connection);
    }

    public function getTableNames() {
        $sql = "SELECT `TABLE_NAME` 
                FROM `INFORMATION_SCHEMA`.`TABLES` 
                WHERE `TABLE_SCHEMA`='{$this->dns['database']}' ";
        return $this->queryCol($sql);

    }

    public function getColumns($table) {
        $sql = "SELECT `COLUMN_NAME` 
                FROM `INFORMATION_SCHEMA`.`COLUMNS` 
                WHERE `TABLE_SCHEMA`='{$this->dns['database']}'  
                AND LOWER(`TABLE_NAME`) = LOWER('{$table}')";
        return $this->queryCol($sql);
    }

    public function getTableKey($table) {
        $sql = "SELECT `COLUMN_NAME` 
                FROM `INFORMATION_SCHEMA`.`COLUMNS` 
                WHERE `TABLE_SCHEMA`='{$this->dns['database']}'  
                AND LOWER(`TABLE_NAME`) = LOWER('{$table}')
                    AND `COLUMN_KEY` = 'PRI'
                    ";
        return $this->queryCol($sql);
    }
    
    public function getPrimaryKeys($table) {
        $sql = "SELECT COLUMN_NAME
                FROM `INFORMATION_SCHEMA`.`COLUMNS`
                WHERE `TABLE_SCHEMA`='{$this->dns['database']}' 
                AND LOWER(`TABLE_NAME`) = LOWER('{$table}')
                AND `COLUMN_KEY` = 'PRI'";
        return $this->queryCol($sql);
    }

    public function checkTableExists($table) {
        $sql = "SELECT LOWER(table_name)
                FROM `INFORMATION_SCHEMA`.`TABLES`
                WHERE `TABLE_SCHEMA`='{$this->dns['database']}' 
                AND LOWER(`TABLE_NAME`) = LOWER('{$table}')";
        try {
            $response = $this->queryOne($sql);
            if ($response != strtolower($table)) {
                return false;
            }
        } catch (\PDOException $e) {
            throw new \Exception("[".__METHOD__."] " . $e->getMessage() . " || " . $sql);
        }
        return true;
    }

    public function getColumnTypes($table) {
        $sql = "SELECT table_name, column_key, column_name, data_type, character_maximum_length, column_type
                FROM `INFORMATION_SCHEMA`.`COLUMNS`
                WHERE `TABLE_SCHEMA`='{$this->dns['database']}' 
                AND LOWER(`TABLE_NAME`) = LOWER('{$table}')";
        try {
            $response = $this->queryAll($sql);
        } catch (\PDOException $e) {
            throw new \Exception("[".__METHOD__."] " . $e->getMessage() . " || " . $sql);
        }
        $colTypes = [];
        foreach ($response as $row) {
            if (empty($row['character_maximum_length']) && ($row['data_type'] == 'decimal' || $row['data_type'] == 'float')) {
                $row['character_maximum_length'] = "18, 6";
            }
            if (empty($row['character_maximum_length']) && stripos($row['column_type'],'(')) {
                preg_match('#\((.*?)\)#', $row['column_type'], $match);
                if (isset($match[1])) {
                    $row['character_maximum_length'] = $match[1];
                }
            }

            $row['generic_type'] = $this->mapGenericType($row['data_type']);
            $colTypes[$row['column_name']] = $row;
        }
        return $colTypes;
    }

    public function mapGenericType($specific) {
        $specific = strtolower($specific);
        switch($specific) {
            case 'int':
            case 'integer':
            case 'tinyint':
            case 'smallint':
            case 'mediumint':
            case 'bigint':
                $general = 'int';
                break;
            case 'float':
            case 'double':
            case 'decimal':
                $general = 'decimal';
                break;
            case 'date':
                $general = 'date';
                break;
            case 'datetime':
            case 'timestamp':
                $general = 'datetime';
                break;
            case 'char':
            case 'varchar':
            case 'blob':
            case 'enum':
            case 'year':
            case 'time':
            case 'text':
            case 'tinyblob':
            case 'tinytext':
            case 'mediumblob':
            case 'mediumtext':
            case 'longblob':
            case 'longtext':
                $general = 'string';
                break;
            default:
                throw new \Exception("Specific Type: '{$specific}' is not mapped, please update.");
                break;
        }
        return $general;
    }

}