<?php

namespace BK\PDO;

class Query {
    private $con;
    private $pre;

    function __construct(\PDO $connection) {
        $this->con = $connection;
    }

    public function query($query) {
        $res = $this->con->query($query);
        return $res;
    }

    public function queryAll($query) {
        $res = $this->con->query($query);
        return $res->fetchAll(\PDO::FETCH_ASSOC);
    }

    public function queryCol($query) {
        $res = $this->con->query($query);
        return $res->fetchAll(\PDO::FETCH_COLUMN);
    }

    public function queryRow($query) {
        $res = $this->con->query($query);
        return $res->fetch(\PDO::FETCH_ASSOC);
    }

    public function queryOne($query) {
        $res = $this->con->query($query);
        $ret = $res->fetch(\PDO::FETCH_COLUMN);
        return $ret;
    }

    public function lastInsertId() {
        return $this->con->lastInsertId();
    }

    public function prepare($query) {
        return new Prepare($query, $this->pre, $this->con);
    }
    public function errorInfo() {
        return $this->con->errorInfo();
    }
    public function errorCode() {
        return $this->con->errorCode();
    }

    public function checkTableExists($table) {
        return false;
    }

    public function getColumnTypes($table) {
        return false;
    }
}