<?php

namespace BK\PDO;
use BK\PDO\Query;

class SQLite extends Query {
    public $dns;
    function __construct(\PDO $connection) {
        parent::__construct($connection);
    }

    public function getTableNames() {
        $sql = "SELECT 
                    name
                FROM 
                    sqlite_master 
                WHERE 
                    type ='table' AND 
                    name NOT LIKE 'sqlite_%' ";
        return $this->queryCol($sql);

    }

    public function tableInfo($table) {
        $sql = "PRAGMA table_info('{$table}');";
        return $this->queryAll($sql);
    }

    public function getColumns($table) {
        $info = $this->tableInfo($table);
        $columns = [];
        foreach($info as $row) {
            $columns[$row['name']] = $row['name'];
        }
        return $columns;
    }

    public function getTableKey($table) {
        $info = $this->tableInfo($table);
        $columns = [];
        foreach($info as $row) {
            if ($row['pk'] == 1) {
                $columns[] = $row['name'];
                break;
            }
        }
        return $columns;
    }

    public function getPrimaryKeys($table) {
        $info = $this->tableInfo($table);
        $columns = [];
        foreach($info as $row) {
            if ($row['pk'] == 1) {
                $columns[] = $row['name'];
            }
        }
        return $columns;
    }

    public function checkTableExists($table) {
        $tables = $this->getTableNames();
        return in_array($table,$tables);
    }

    public function getColumnTypes($table) {
        $info = $this->tableInfo($table);
        $colTypes = [];
        foreach ($info as $row) {
            if (!isset($row['character_maximum_length'])) {
                $row['character_maximum_length'] = '';
            }
            if (empty($row['character_maximum_length']) && ($row['type'] == 'decimal' || $row['type'] == 'float')) {
                $row['character_maximum_length'] = "18, 6";
            }
            if (empty($row['character_maximum_length']) && stripos($row['type'],'(')) {
                preg_match('#\((.*?)\)#', $row['column_type'], $match);
                if (isset($match[1])) {
                    $row['character_maximum_length'] = $match[1];
                }
            }

            $row['generic_type'] = $this->mapGenericType($row['type']);
            $colTypes[$row['name']] = $row;
        }
        return $colTypes;
    }

    public function mapGenericType($specific) {
        $specific = strtolower($specific);
        switch($specific) {
            case 'int':
            case 'integer':
            case 'tinyint':
            case 'smallint':
            case 'mediumint':
            case 'bigint':
                $general = 'int';
                break;
            case 'float':
            case 'real':
            case 'double':
            case 'decimal':
                $general = 'decimal';
                break;
            case 'date':
                $general = 'date';
                break;
            case 'datetime':
            case 'timestamp':
                $general = 'datetime';
                break;
            case 'char':
            case 'varchar':
            case 'blob':
            case 'enum':
            case 'year':
            case 'time':
            case 'text':
            case 'tinyblob':
            case 'tinytext':
            case 'mediumblob':
            case 'mediumtext':
            case 'longblob':
            case 'longtext':
                $general = 'string';
                break;
            default:
                throw new \Exception("Specific Type: '{$specific}' is not mapped, please update.");
                break;
        }
        return $general;
    }

}