<?php
namespace BK\Record;

use BK\PDO\SQLite;
use BK\Record;

class Attachment extends Record {
    public $table = 'attachment';
    function __construct(SQLite $db, $id = null) {
        parent::__construct($db, $id);
    }

    function getAttachmentByType($id, $type) {
        return $this->db->prepare("
            SELECT * FROM attachment WHERE attached_id = ? AND attached_type = ?
            ")->execute([$id, $type])->fetchAll();
    }

    function getCount($id, $type) {
        return $this->db->prepare("SELECT COUNT(*) FROM attachment WHERE attached_id = ? AND attached_type = ?")->execute([$id,$type])->fetchOne();
    }

    function delete($id) {
        $attachment = parent::get($id);
        if (file_exists($attachment['path'])) {
            unlink($attachment['path']);
        }
        return parent::delete($id);
    }



}