<?php
namespace BK\Record;

use BK\PDO\SQLite;
use BK\Record;

class Category extends Record {
    public $table = 'categories';
    function __construct(SQLite $db, $id = null) {
        parent::__construct($db, $id);
    }

    function load($id) {
        $data = parent::load($id);
        if ($data && $data['type'] != '') {
            $data['type'] = explode(',',$data['type']);
        } else {
            $data['type'] = [];
        }
        return $data;
    }

    function save($params = null) {
        if (isset($params['category_name'])) {
            $params['name'] = $params['category_name'];
        }
        if (isset($params['category_type'])) {
            $params['type'] = $params['category_type'];
        }
        if (is_array($params['type'])) {
            $params['type'] = implode(',',$params['type']);
        }
        return parent::save($params);
    }

    function listByType($type = []) {
        $typeOrder = ['INV','PYMT','BILL'];
        $typeFilter = [];
        if (is_string($type)) {
            $type = [$type];
        }
        foreach ($typeOrder as $typeName) {
            if (in_array($typeName,$type)) {
                $typeFilter[] = $typeName;
            }
        }
        return $this->db->prepare("
            SELECT 
                *
            FROM
                categories
            WHERE
                instr(type, ?) > 0
            ")
            ->execute([implode(',',$typeFilter)])->fetchAll();
    }



}