<?php
namespace BK\Record;

use BK\PDO\SQLite;
use BK\Record;

class Invoice extends Record {
    public $table = 'invoice';
    function __construct(SQLite $db, $id = null) {
        parent::__construct($db, $id);
    }

    public function listAll($where = "", $values = []) {
        $sql = "
            SELECT 
                i.*, 
                v.name AS vehicle_name,
                e.name AS entity_name,
                e.id AS entity_id,
                (
                    SELECT 
                        SUM(t.`amount` * il.quantity) * -1 
                    FROM `transaction` AS t
                        LEFT JOIN invoice_line AS il ON il.id = t.invoice_line_id
                    WHERE  (t.invoice_id = i.id OR t.workorder_id = i.workorder_id)  AND t.`amount` < 0) AS cost_value,
                (SELECT SUM(`amount`) FROM `transaction` WHERE (invoice_id = i.id OR workorder_id = i.workorder_id) AND `amount` > 0) AS paid_value,
                CASE  
                    WHEN i.active = '0' THEN 'Inactive'
                    WHEN i.active = '1' THEN 'Active'
                    WHEN i.active = '2' THEN 'Paid'
                END status_name
            FROM invoice AS i    
                LEFT JOIN `workorder` AS wo ON i.workorder_id = wo.id
                LEFT JOIN entity AS e ON e.id = wo.entity_id
                LEFT JOIN vehicle v on v.id = wo.vehicle_id
            WHERE
                i.id > 0 {$where}
            ";
        $prep = $this->db->prepare($sql);
        return $prep->execute($values)->fetchAll();
    }

    public function getByWorkOrder($id) {
        $sql = "
            SELECT 
                *
            FROM invoice AS i  
            WHERE
                i.workorder_id = ?
            ";
        $prep = $this->db->prepare($sql);
        return $prep->execute($id)->fetchRow();
    }

    public function isPaid($id) {
        $sql = "
            SELECT 
                i.*,
                (
                    SELECT 
                        SUM(t.`amount` * il.quantity) * -1 
                    FROM `transaction` AS t
                        LEFT JOIN invoice_line AS il ON il.id = t.invoice_line_id
                    WHERE  (t.invoice_id = i.id OR t.workorder_id = i.workorder_id)  AND t.`amount` < 0) AS cost_value,
                (SELECT SUM(`amount`) FROM `transaction` WHERE (invoice_id = i.id OR workorder_id = i.workorder_id) AND `amount` > 0) AS paid_value,
                CASE  
                    WHEN i.active = '0' THEN 'Inactive'
                    WHEN i.active = '1' THEN 'Active'
                    WHEN i.active = '2' THEN 'Paid'
                END status_name
            FROM invoice AS i    
                LEFT JOIN `workorder` AS wo ON i.workorder_id = wo.id
            WHERE
                i.id = ?
            ";
        $prep = $this->db->prepare($sql);
        $invoice = $prep->execute($id)->fetchRow();
        return ((float)$invoice['paid_value'] >= (float)$invoice['cost_value']);
    }



}