<?php
namespace BK\Record;

use BK\PDO\SQLite;
use BK\Record;

class InvoiceLine extends Record {
    public $table = 'invoice_line';
    function __construct(SQLite $db, $id = null) {
        parent::__construct($db, $id);
    }

    public function getByInvoice($id) {
        if ($id === 'new') {
            return [];
        }
        return $this->db->prepare("
            SELECT 
                   invl.*,
                   (cost.amount) * -1 AS cost_value
            FROM invoice_line AS invl 
            LEFT JOIN 'transaction' AS cost ON cost.id = invl.cost_tran_id
            WHERE invl.invoice_id = ?
        ")->execute($id)->fetchAll();
    }

    public function getTotalByWorkOrder($id) {
        if ($id === 'new') {
            return 0;
        }
        return $this->db->prepare("
            SELECT 
                   SUM(cost.amount * invl.quantity ) * -1 AS cost_value
            FROM invoice_line AS invl 
                LEFT JOIN invoice AS inv ON inv.id = invl.invoice_id
                LEFT JOIN 'transaction' AS cost ON cost.id = invl.cost_tran_id
            WHERE inv.workorder_id  = ?
        ")->execute($id)->fetchOne();
    }

    public function getTotalByInvoice($id) {
        if ($id === 'new') {
            return 0;
        }
        return $this->db->prepare("
            SELECT 
                   SUM(cost.amount * invl.quantity ) * -1 AS cost_value
            FROM invoice_line AS invl 
            LEFT JOIN 'transaction' AS cost ON cost.id = invl.cost_tran_id
            WHERE invl.invoice_id = ?
        ")->execute($id)->fetchOne();

    }


}