<?php
namespace BK\Record;

use BK\PDO\SQLite;
use BK\Record;

class Project extends Record {
    public $table = 'projects';
    function __construct(SQLite $db, $id = null) {
        parent::__construct($db, $id);
    }

    function listByCustomer($id) {
        if ($id == 'new'){
            return [];
        }
        return $this->db->prepare("SELECT * FROM projects WHERE customer_id = ?")
            ->execute($id)->fetchAll();
    }
    function load($id) {
        parent::load($id);
        if ($this->record && trim($this->record['budget']) != '') {
            $this->record['budget'] = number_format(((float)$this->record['budget']/100),2);
        }
        return $this->record;
    }

    function save($params = null) {
        if (isset($params['completed_on']) && trim($params['completed_on']) != '' && !is_int($params)) {
            $params['completed_on'] = strtotime($params['completed_on']);
        }
        return parent::save($params);
    }


}