<?php
namespace BK\Record;

use BK\PDO\SQLite;
use BK\Record;

class Search extends Record {
    public $table = 'customers';
    function __construct(SQLite $db, $id = null) {
        parent::__construct($db, $id);
    }

    public function _global($string) {
        $string = "%{$string}%";
        $values = [];
        // UNION ALL
        $sql = "
            SELECT c.id, c.name, c.phone AS description1, c.email AS description2, c.type AS type
            FROM customers AS c
            WHERE c.name LIKE ? OR c.phone LIKE ? OR c.email LIKE ?
            UNION ALL
            SELECT p.id, p.name, '' AS description1, '' AS description2, 'project' as type
            FROM projects AS p
            WHERE p.name LIKE ?
            UNION ALL
            SELECT t.id, t.type || t.id AS name, t.memo AS description1, t.reference AS description2, t.type AS type
            FROM transactions AS t 
            WHERE t.type || t.id LIKE ? OR t.memo LIKE ? OR t.reference LIKE ?
            ";
        for ($index = 0; $index < substr_count($sql,"?"); $index++) {
            $values[] = $string;
        }
        return $this->db->prepare($sql)
            ->execute($values)->fetchAll();
    }



}