<?php
namespace BK\Record;

use BK\PDO\SQLite;
use BK\Record;

class Setting extends Record {
    public $table = 'settings';
    function __construct(SQLite $db, $id = null) {
        parent::__construct($db, $id);
    }

    function set($field, $value) {
        return $this->db->prepare("REPLACE INTO settings (field, value) VALUES (?,?)")
            ->execute([$field, $value]);
    }

    function get($field) {
        return $this->db->prepare("SELECT value FROM settings WHERE field = ?")
            ->execute($field)->fetchOne();
    }


}