<?php
namespace BK\Record;

use BK\PDO\SQLite;
use BK\Record;

class Transaction extends Record {
    public $table = 'transaction';
    function __construct(SQLite $db, $id = null) {
        parent::__construct($db, $id);
    }

    public function reportList($from = null, $to = null) {
        $categories = \BK\Utils::workOrderCategories();
        $values = [];
        $where = [];
        if ($from) {
            $values[] = $from;
            $where[] = "t.created_on >= ?";
        }
        if ($to) {
            $values[] = $to;
            $where[] = "t.created_on <= ?";
        }
        $sql = "
            SELECT
                t.*,
                CASE 
                    WHEN (t.invoice_id IS NOT NULL 
                        OR t.invoice_id != '') 
                        AND (t.workorder_id IS NOT NULL 
                        OR t.workorder_id != '')
                        AND t.amount > 0 THEN 'Payment'
                    WHEN t.invoice_line_id IS NOT NULL 
                        AND t.invoice_line_id != '' 
                        AND (t.workorder_line_id IS NULL 
                        OR t.workorder_line_id = '')
                        AND t.amount < 0 THEN 'Invoice'
                    WHEN (t.invoice_id IS NULL 
                        OR t.invoice_id = '')
                        AND (t.workorder_id IS NOT NULL 
                        AND t.workorder_id != '')
                        AND t.amount < 0 THEN 'WorkOrder'
                    ELSE 'Uknown'
                END AS `type`,
                CASE 
                    WHEN (t.invoice_id IS NOT NULL 
                        OR t.invoice_id != '') 
                        AND (t.workorder_id IS NOT NULL 
                        OR t.workorder_id != '')
                        AND t.amount > 0 THEN 'Money In'
                    WHEN t.invoice_line_id IS NOT NULL 
                        AND t.invoice_line_id != '' 
                        AND (t.workorder_line_id IS NULL 
                        OR t.workorder_line_id = '')
                        AND t.amount < 0 THEN 'Charge'
                    WHEN (t.invoice_id IS NULL 
                        OR t.invoice_id = '')
                        AND (t.workorder_id IS NOT NULL 
                        AND t.workorder_id != '')
                        AND t.amount < 0 THEN 'Money Out'
                    ELSE 'Uknown'
                END AS `account`,
                CASE 
                    WHEN t.invoice_line_id IS NOT NULL AND t.invoice_line_id != '' AND l.name = ''
                        THEN 'INV' || t.invoice_id || ' line ' || l.line_number
                    WHEN t.invoice_line_id IS NOT NULL AND t.invoice_line_id != '' AND l.name != ''
                        THEN l.name
                    WHEN t.workorder_line_id IS NOT NULL AND t.workorder_line_id != '' AND wol.name = ''
                        THEN 'WO' || t.workorder_id || ' line ' || wol.line_number
                    WHEN t.workorder_line_id IS NOT NULL AND t.workorder_line_id != '' AND wol.name != ''
                        THEN wol.name
                    ELSE t.`identifier`
                END AS description,
                CASE 
                    WHEN t.invoice_line_id IS NOT NULL AND t.invoice_line_id != '' 
                        THEN l.category_id
                    WHEN t.workorder_line_id IS NOT NULL AND t.workorder_line_id != '' 
                        THEN wol.category_id
                    ELSE ''
                END AS category_id,
                CASE 
                    WHEN t.invoice_line_id IS NOT NULL AND t.invoice_line_id != '' THEN (t.`amount` * l.quantity)
                    WHEN t.workorder_line_id IS NOT NULL AND t.workorder_line_id != '' THEN (t.`amount` * wol.quantity)
                    ELSE t.`amount`
                END AS full_amount,
                wol.line_number AS workorder_line_num,
                l.line_number AS invoice_line_num
            FROM
                `transaction` AS t
                LEFT JOIN `workorder` AS wo ON wo.id = t.workorder_id
                LEFT JOIN `workorder_line` AS wol ON wol.id = t.workorder_line_id
                LEFT JOIN `invoice` AS i ON i.id = t.invoice_id
                LEFT JOIN `invoice_line` AS l ON l.id = t.invoice_line_id
            WHERE
                i.active > 0 OR wo.active > 0
             " . (count($where) > 0 ? " AND " . implode(" AND ", $where) : "");
        $prep = $this->db->prepare($sql);
        $rows = $prep->execute($values)->fetchAll();
        foreach ($rows as $index => $row) {
            if (isset($categories[$row['category_id']])) {
                $rows[$index]['category_name'] = $categories[$row['category_id']];
            } else {
                $rows[$index]['category_name'] = '';
            }
        }
        return $rows;
    }

    public function getPaymentsByWorkOrder($id) {
        return $this->db->prepare("
            SELECT  
                t.*,
                a.path AS attachment_path
            FROM
            `transaction` t 
            LEFT JOIN `attachment` a ON a.id = t.attachment_id
            WHERE t.workorder_id = ? AND t.amount > 0
        ")->execute([$id])->fetchAll();

    }

    public function getReceived($from, $to) {
        $results = $this->db->prepare("
            SELECT SUM(`amount`) FROM `transaction` WHERE created_on >= ? AND created_on <= ? AND `amount` > 0 AND workorder_id IS NOT NULL AND workorder_id != ''
        ")->execute([$from, $to])->fetchOne();

        return $results;
    }

    public function getInvoiced($from, $to) {
        return $this->db->prepare("
            SELECT 
                SUM(t.`amount` * il.quantity) * -1 
            FROM `transaction` AS t
                LEFT JOIN invoice_line AS il ON il.id = t.invoice_line_id
            WHERE t.invoice_line_id != '' 
            AND t.created_on >= ? 
            AND t.created_on <= ? 
            AND t.`amount` < 0
        ")->execute([$from, $to])->fetchOne();
    }

    public function getBalance($from = null, $to = null) {
        $values = [];
        $where = [];
        if ($from) {
            $values[] = $from;
            $where[] = "t.created_on >= ?";
        }
        if ($to) {
            $values[] = $to;
            $where[] = "t.created_on <= ?";
        }
        $sql = "
            SELECT
                SUM(
                CASE WHEN t.invoice_line_id = '' OR t.invoice_line_id IS NULL
                     THEN t.amount
                     ELSE (t.`amount` * l.quantity)
                END) AS full_amount
            FROM
                `transaction` AS t
                LEFT JOIN `workorder` AS wo ON wo.id = t.workorder_id
                LEFT JOIN `invoice` AS i ON i.id = t.invoice_id
                LEFT JOIN `invoice_line` AS l ON l.id = t.invoice_line_id
            WHERE
                (i.active > 0 OR wo.active > 0)
              AND (t.workorder_line_id = '' OR t.workorder_line_id IS NULL)
             " . (count($where) > 0 ? " AND " . implode(" AND ", $where) : "");
        $prep = $this->db->prepare($sql);
        return $prep->execute($values)->fetchOne();
    }



}