<?php
namespace BK\Record;

use BK\PDO\SQLite;
use BK\Record;

class TransactionLine extends Record {
    public $table = 'transaction_lines';
    function __construct(SQLite $db, $id = null) {
        parent::__construct($db, $id);
    }

    public function listByProjectId($projectId, $type = '') {
        if ($projectId == 'new') {
            return [];
        }
        if ($type !== '') {
            $type = "AND t.type = '{$type}'";
        }
        return $this->db->prepare("
            SELECT 
                tl.*,
                c.name AS category_name
            FROM 
                transaction_lines AS tl
                LEFT JOIN transactions t on tl.transaction_id = t.id
                LEFT JOIN categories c on tl.category_id = c.id
            WHERE tl.project_id = ? {$type}
        ")->execute($projectId)->fetchAll();
    }

    public function listByTransactionId($transactionId) {
        if ($transactionId == 'new') {
            return [];
        }
        return $this->db->prepare("
            SELECT * FROM transaction_lines WHERE transaction_id = ?
        ")->execute($transactionId)->fetchAll();
    }

    public function deleteByTransactionId($transactionId) {
        if ($transactionId == 'new') {
            return true;
        }
        return $this->db->prepare("
            DELETE FROM transaction_lines WHERE transaction_id = ?
        ")->execute($transactionId);
    }

    public function getBalance($type = null, $where = null) {
        $sql = "
            SELECT 
                SUM(amount) 
            FROM transaction_lines AS tl
            LEFT JOIN transactions t on tl.transaction_id = t.id
        ";
        if ($type || $where) {
            $sql .= " WHERE";
        }
        if ($type) {
            $sql .= " t.type = '{$type}'";
        }
        if ($where) {
            $sql .= " {$where}";
        }
        return $this->db->queryOne($sql);
    }




}