<?php
namespace BK\Record;

use BK\PDO\SQLite;
use BK\Record;

class TransactionsOld extends Record {
    public $table = 'transactions';
    function __construct(SQLite $db, $id = null) {
        parent::__construct($db, $id);
    }

    function listByCustomer($id, $type = 'INV') {
        if ($id == 'new'){
            return [];
        }
        return $this->db->prepare("
            SELECT 
                t.*, 
                (SELECT SUM(tl.amount) 
                FROM transaction_lines AS tl 
                WHERE tl.transaction_id = t.id) AS amount   
            FROM transactions AS t WHERE t.customer_id = ? AND t.type = ?")
            ->execute([$id, $type])->fetchAll();
    }

    /**
     * @param string $type INV | PYMT | BILL
     * @param string $relatedTo
     * @param string $projectId
     * @return mixed
     */
    function listByType(string $type = 'INV', $relatedTo = null, $projectId = null) {
        $values = [$type];
        $where = '';
        if ($relatedTo) {
            $values[] = $relatedTo;
            $where .= " AND related_to = ?";
        }
        if ($projectId) {
            $values[] = $projectId;
            $where .= " AND project_id = ?";
        }
        return $this->db->prepare("
            SELECT 
                t.*, 
                c.name AS customer_name,
                p.name AS project_name,
                (SELECT SUM(tl.amount) 
                FROM transaction_lines AS tl 
                WHERE tl.transaction_id = t.id) AS amount   
            FROM transactions AS t 
            LEFT JOIN customers c on t.customer_id = c.id
            LEFT JOIN projects p on t.project_id = p.id
            WHERE t.type = ? {$where}
            ")
            ->execute($values)->fetchAll();
    }

    // TODO need to make specific calls for related to by TYPE BILL, PYMNT and INV ^^

    function listWithRelated(string $type = 'INV') {

        return $this->db->prepare("
            SELECT 
                t.*, 
                c.name AS customer_name,
                p.name AS project_name,
                (SELECT type || id FROM transactions WHERE id = t.related_to) AS related_name,
                (SELECT SUM(tl.amount) 
                FROM transaction_lines AS tl 
                WHERE tl.transaction_id = t.id) AS amount   
            FROM transactions AS t 
            LEFT JOIN customers c on t.customer_id = c.id
            LEFT JOIN projects p on t.project_id = p.id
            WHERE t.type = ?
            ")
            ->execute([$type])->fetchAll();
    }

    public function openInvoices() {
        $sql = "
            SELECT 
                t.*, 
                c.name AS customer_name,
                p.name AS project_name,
                (SELECT type || id FROM transactions WHERE id = t.related_to) AS related_name,
                (
                    SELECT SUM(tl.amount) 
                    FROM transaction_lines AS tl 
                    WHERE tl.transaction_id = t.id
                ) AS amount,
                (
                    SELECT SUM(tl.amount) 
                    FROM transaction_lines AS tl 
                    LEFT JOIN transactions t2 on tl.transaction_id = t2.id
                    WHERE tl.related_to = t.id AND t2.type = 'PYMT'
                ) AS payment,
                   (
                    SELECT COUNT(tl.id) 
                    FROM transaction_lines AS tl 
                    LEFT JOIN transactions t2 on tl.transaction_id = t2.id
                    WHERE tl.related_to = t.id AND t2.type = 'PYMT'
                ) AS payment_count
            FROM transactions AS t 
            LEFT JOIN customers c on t.customer_id = c.id
            LEFT JOIN projects p on t.project_id = p.id
            WHERE payment < amount OR payment_count = 0
        ";
        return $this->db->queryAll($sql);
    }

    function listInvoicesWithRemainingDue() {
        $invoices = $this->listByType('INV');
        $remainPrep = $this->db->prepare("
            SELECT 
                SUM(tl.amount) AS total_amount,
                COUNT(t.id) AS total_records
            FROM 
                transaction_lines AS tl
                LEFT JOIN transactions t on tl.transaction_id = t.id
            WHERE
                tl.related_to = ? AND t.type = 'PYMT'
        ");
        $result = [];
        foreach ($invoices as $inv) {
            $payments = $remainPrep->execute($inv['id'])->fetchRow();
            $payments = (empty($payments) ? ['total_amount'=>0,'total_records'=>0] : $payments);
            $inv['remaining'] = (float)$inv['amount'] - (float)$payments['total_amount'];
            $inv['payment_records'] = $payments['total_records'];
            $inv['payment_total'] = $payments['total_amount'];
            $result[] = $inv;
        }
        return $result;
    }

    function save($params = null) {
        if (isset($params['due_on'])) {
            $params['due_on'] = strtotime($params['due_on']);
        }
        return parent::save($params);

    }



}