<?php
namespace BK\Record;

use BK\PDO\SQLite;
use BK\Record;

class Vehicle extends Record {
    public $table = 'vehicle';
    function __construct(SQLite $db, $id = null) {
        parent::__construct($db, $id);
    }

    public function listAll($where = "", $values = []) {
        $workorder = new Workorder($this->db);
        $sql = "
            SELECT 
                v.*
            FROM vehicle AS v 
            WHERE
                v.active > 0 {$where}
            ";

        $prep = $this->db->prepare($sql);
        $rows =  $prep->execute($values)->fetchAll();
        foreach ($rows as $index => $row) {
            $workorders = $workorder->listAll("AND wo.vehicle_id = ?", [$row['id']]);
            $rows[$index]['paid_value'] = 0;
            $rows[$index]['invoice_value'] = 0;
            $rows[$index]['cost_value'] = 0;
            foreach ($workorders as $wo) {
                $rows[$index]['paid_value'] += (float)$wo['paid_value'];
                $rows[$index]['invoice_value'] += (float)$wo['invoice_value'];
                $rows[$index]['cost_value'] += (float)$wo['cost_value'];
            }
        }
        return $rows;
    }

    public function listAllWorkOrders($where = "", $values = []) {
        $sql = "
            SELECT 
                wo.*,
                v.name AS vehicle_name,
                v.year AS vehicle_year,
                v.make_model AS vehicle_make_model,
                e.name AS entity_name,
                (SELECT SUM(`amount`) FROM `transaction` WHERE workorder_id = wo.id AND `amount` > 0) AS paid_value,
                (SELECT SUM(`amount` * -1) FROM `transaction` WHERE workorder_id = wo.id AND `amount` < 0) AS cost_value
            FROM `workorder` AS wo
                LEFT JOIN entity AS e ON e.id = wo.entity_id
                LEFT JOIN vehicle v on v.id = wo.vehicle_id
            WHERE
                wo.active > 0 {$where}
            ";
        $prep = $this->db->prepare($sql);
        return $prep->execute($values)->fetchAll();
    }



}