<?php
namespace BK\Record;

use BK\PDO\SQLite;
use BK\Record;

class Workorder extends Record {
    public $table = 'workorder';
    function __construct(SQLite $db, $id = null) {
        parent::__construct($db, $id);
    }

    public function listAll($where = "", $values = []) {
        $sql = "
            SELECT 
                wo.*,
                v.name AS vehicle_name,
                e.name AS entity_name,
                (SELECT SUM(t.`amount`) FROM `transaction` AS t WHERE t.workorder_id = wo.id AND t.`amount` > 0) AS paid_value,
                (
                    SELECT SUM((t.`amount` * -1) * wol.quantity) 
                    FROM `transaction` AS t 
                        LEFT JOIN `workorder_line` AS wol ON wol.id = t.workorder_line_id
                    WHERE t.workorder_id = wo.id AND t.`amount` < 0
                ) AS cost_value,
                (
                    SELECT 
                    SUM(cost.amount * invl.quantity ) * -1
                    FROM invoice_line AS invl 
                        LEFT JOIN invoice AS inv ON inv.id = invl.invoice_id
                        LEFT JOIN 'transaction' AS cost ON cost.id = invl.cost_tran_id
                    WHERE inv.workorder_id = wo.id
                ) AS invoice_value,
                CASE  
                    WHEN wo.active = '0' THEN 'Inactive'
                    WHEN wo.active = '1' THEN 'Active'
                    WHEN wo.active = '2' THEN 'Paid'
                END status_name
            
            FROM `workorder` AS wo
                LEFT JOIN entity AS e ON e.id = wo.entity_id
                LEFT JOIN vehicle v on v.id = wo.vehicle_id
            WHERE
                wo.active > 0 {$where}
            ";
        $prep = $this->db->prepare($sql);
        return $prep->execute($values)->fetchAll();
    }

    public function getTotalPaidByWorkOrder($id) {
        if ($id === 'new') {
            return 0;
        }
        return $this->db->prepare("
            SELECT 
                   SUM(t.amount) AS paid_value
            FROM `transaction` AS t 
            WHERE t.workorder_id = ? AND t.amount > 0
        ")->execute($id)->fetchOne();
    }



}