<?php
namespace BK\Record;

use BK\PDO\SQLite;
use BK\Record;

class WorkorderLine extends Record {
    public $table = 'workorder_line';
    function __construct(SQLite $db, $id = null) {
        parent::__construct($db, $id);
    }

    public function getByWorkOrder($id) {
        if ($id === 'new') {
            return [];
        }
        return $this->db->prepare("
            SELECT 
                   wol.*,
                   paid.amount AS paid_value,
                   (cost.amount) * -1 AS cost_value
            FROM workorder_line AS wol 
            LEFT JOIN 'transaction' AS cost ON cost.id = wol.cost_tran_id
            LEFT JOIN 'transaction' AS paid ON paid.id = wol.paid_tran_id
            WHERE wol.workorder_id = ?
        ")->execute($id)->fetchAll();
    }

    public function getTotalDueByWorkOrder($id) {
        if ($id === 'new') {
            return 0;
        }
        return $this->db->prepare("
            SELECT 
                   SUM(cost.amount * wol.quantity ) * -1 AS cost_value
            FROM workorder_line AS wol 
            LEFT JOIN 'transaction' AS cost ON cost.id = wol.cost_tran_id
            LEFT JOIN 'transaction' AS paid ON paid.id = wol.paid_tran_id
            WHERE wol.workorder_id = ?
        ")->execute($id)->fetchOne();
    }

    public function getTotalPaidByWorkOrder($id) {
        if ($id === 'new') {
            return 0;
        }
        return $this->db->prepare("
            SELECT 
                   SUM(paid.amount) AS paid_value
            FROM workorder_line AS wol 
            LEFT JOIN 'transaction' AS cost ON cost.id = wol.cost_tran_id
            LEFT JOIN 'transaction' AS paid ON paid.id = wol.paid_tran_id
            WHERE wol.workorder_id = ?
        ")->execute($id)->fetchOne();
    }


}