<?php
namespace BK;

use BK\Record\Access;
use BK\Record\Setting;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Slim\Container;
use Slim\Views\Twig;

class Route {
    public $app;
    public $view;
    public $dir;
    public $uri;
    public $params;
    public $env;
    public $route;

    public $request;
    public $response;

    public $template;
    public $context;
    public $display = true;
    public $hideLog = false;
    public $error_message;
    public $jsonOnly = false;
    public $passthrough = null;
    public $access;
    public $public = false;
    public $error = false;

    private $base = ['css'=>'/css/', 'js'=>'/js/'];

    public $css = [
        'bootstrap.4.5.2',
        'theme.bootstrap_4.min',
        'sb-admin',
        'all',
    ];
    public $js = [
        'jquery.3.5.1',
        'popper',
        'bootstrap.4.5.2',
        'momentjs.2.29.1',
        'chart.2.9.3',
        'tablesorter.2.31.3',
        'utils'
    ];
    public $dateFormat = [
        'list' => 'm/d/Y',
        'input' => 'Y-m-d'
    ];

    function __construct() {
        $this->css($this->css);
        $this->js($this->js);
    }

    /**
     * Populating the config for onelogin on setApp
     *
     * @param Container $app
     * @param Twig $view
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @param $route
     */
    public function setApp(Container $app, Twig $view, ServerRequestInterface $request, ResponseInterface $response, $route) {
        $this->app = $app;

        /* @var $view Twig */
        $this->view = $view;
        $this->request = $request;
        $this->response = $response;
        $this->setRoute($route);
        $this->setUri();
        $this->setDirectory();
        $this->setParams();
    }

    public function newLog($name) {
        $logger = new \Monolog\Logger($name);
        $base = str_replace(['/src','/classes','/BK','/Route'],'',__DIR__);
        $file_handler = new \Monolog\Handler\StreamHandler($base . '/logs/'.$name.'-'. date('Y-m-d') . '.log');
        $logger->pushHandler($file_handler);
        return $logger;
    }

    private function setParams() {
        $this->params = $this->request->getQueryParams();
        if (!is_array($this->params)) {
            $this->params = [];
        }
        if ($this->app->_uri->method != "get" ) {
            $this->params = array_merge($this->params,$this->request->getParsedBody());
        }
        if ((!isset($this->params['id']) || empty($this->params['id'])) && !empty($this->classId)) {
            $this->params['id'] = $this->classId;
        }
        if ((!isset($this->params['id']) || empty($this->params['id'])) && !empty($this->route['id'])) {
            $this->params['id'] = $this->route['id'];
        }
    }

    private function setDirectory() {
        $this->dir = $this->app->_dir;
    }

    private function setUri() {
        $this->uri = $this->app->_uri;
    }

    public function setRoute($route) {
        $this->route = [
            'class' => $route->className,
            'method' => $route->classMethod,
            'id' => $route->classId
        ];
    }

    public function setTitle($title) {
        $this->assign('title', $title);
    }

    public function setPublic($value) {
        $this->public = $value;
    }
    public function isPublic() {
        return $this->public;
    }

    public function message($message, $type = 'info', $key = null) {
        if (!isset($_SESSION['system_message'])) {
            $_SESSION['system_message'] = [];
        }
        if ($key) {
            $_SESSION['system_message'][$key] = [
                'type' => $type,
                'msg' => $message
            ];
        } else {
            $_SESSION['system_message'][] = [
                'type' => $type,
                'msg' => $message
            ];
        }
        return true;
    }

    public function clearMessage() {
        if (isset($_SESSION['system_message'])) {
            unset($_SESSION['system_message']);
        }
    }

    public function push($variable, $values) {
        if (!is_array($values)) {
            $values = [$values];
        }
        foreach ($values as $value) {
            if (isset($this->base[$variable])) {
                $value = $this->base[$variable] . $value;
            }
            $this->context[$variable][] = $value;
        }
        return true;
    }

    public function js($values) {
        $this->push('js', $values);
        return true;
    }

    public function css($values) {
        $this->push('css', $values);
        return true;
    }

    public function get($variable) {
        return $this->context[$variable];
    }

    public function unassign($variable) {
        unset($this->context[$variable]);
        return true;
    }

    public function setTemplate($template) {
        $this->template = $template;
    }

    public function assign($variable, $value) {
        if (is_string($variable)) {
            $variable = [$variable];
        }
        foreach($variable as $field) {
            $this->context[$field] = $value;
        }
    }

    public function context($context) {
        foreach ($context as $variable => $value) {
            $this->assign($variable, $value);
        }
    }
    public function error($message) {
        $this->error = true;
        $this->error_message = $message;
    }

    public function display($is = true) {
        $this->display = $is;
    }

    public function hideLog($is = true) {
        $this->hideLog = $is;
    }

    public function hideMenu($is = true) {
        if ($is) {
            $this->assign('hideMenu', true);
        } else {
            $this->unassign('hideMenu');
        }
    }

    public function _get() {

    }

    public function _post() {

    }

    public function renderView() {

        if (empty($this->template)) {
            $this->template = 'dashboard';
        }
        if ((isset($this->params['ajaxRequest']) && $this->params['ajaxRequest']) || $this->jsonOnly) {
            $this->context['title'] = "Ajax Request";
        }
        if (isset($this->context['title'])) {
            $this->assign('title', Utils::$appName . ' :: ' . $this->context['title']);
        } else {
            $this->assign('title', Utils::$appName . ' :: ' . ucwords(str_replace(['/','-'], ' ', $this->template)));
        }

        if ($this->display) {
            $this->assign('redirect', (isset($_SESSION['redirect']) ? $_SESSION['redirect'] : '/'));
            $this->assign('error_message', ($this->error ? $this->error_message : ''));
            $this->assign('success', ($this->error ? false : true));
            $this->assign('_uri', $this->app->_uri);
            $this->assign('_params', $this->params);
            $this->assign('_session', $_SESSION);
            /* @var $view Twig */
            $view = $this->view;
            if ((isset($this->params['_json']) && $this->params['_json']) || $this->jsonOnly) {
                header('Content-Type: application/json');
                $result = $this->context;
                if (trim($this->template) != '') {
                    $result['template'] = "{$this->template}.twig";
                    $result['html'] = $view->fetch("{$this->template}.twig", $this->context);
                }
                if ($this->passthrough !== null && isset($result[$this->passthrough])) {
                    $result = $result[$this->passthrough];
                }
                echo json_encode($result);
                die();
            } else {
                $setting = new \BK\Record\Setting($this->app['db']);
                $this->assign('_app', [
                    'name' => Utils::$appName,
                ]);
                $this->assign('_theme', $setting->get('theme'));
                $this->assign('_server', $_SERVER);
                $this->assign('_session', $_SESSION);
                $this->assign('_request', $_REQUEST);
                $this->assign('_route', $this->route);
                $this->assign('_dateFormat', $this->dateFormat);
                $this->clearMessage();
                return $view->render($this->response, "{$this->template}.twig", $this->context);
            }
        } else {
            $this->display(true);
        }
    }

    static function response() {
        $response = new \stdClass();
        $response->className = "\\BK\\Route\\Dashboard";
        $response->classMethod = "_get";
        $response->classId = null;
        $response->method = null;
        $response->ignore = [
            "\BK\Route\Favicon.ico",
            "\BK\Route\Data:image",
            "\BK\Route\Css",
            "\BK\Route\Js"
        ];
        return $response;
    }
    
    static function create(Container $app) {
//        $parts = explode("/", ltrim($app->_uri->request,"/"));
        $parts = [
            isset($_REQUEST['_route']) ? $_REQUEST['_route'] : '',
            isset($_REQUEST['_action']) ? $_REQUEST['_action'] : '',
            isset($_REQUEST['_id']) ? $_REQUEST['_id'] : '',
        ];
        $response = self::response();
        if (isset($parts[0]) && $parts[0] != '') {
            $response->className = "\\BK\\Route\\" . Utils::dashToCamel($parts[0]);
        } else {
            $response->className = "\\BK\\Route\\Dashboard";
        }
        if (isset($parts[1]) && $parts[1] != '') {
            $response->classMethod = '_' . $app->_uri->method . '_' . Utils::dashToCamel($parts[1], true);
        } else {
            $response->classMethod = '_' . $app->_uri->method;
        }
        if (isset($parts[2]) && $parts[2] != '' && $parts[2] != 'new') {
            $response->classId = $parts[2];
        }
        $response->method = $app->_uri->method;

        if (in_array($response->className, $response->ignore)) {
            die('Ignored');
        }

        if (!class_exists($response->className)) {
            throw new \Exception("Module '{$response->className}' does not exist");
        }

        if (!method_exists($response->className, $response->classMethod)) {
            throw new \Exception("Module '{$response->className}'->'{$response->classMethod}' is not supported");
        }
        return $response;
    }
}