<?php
namespace BK\Route;

use BK\Route;
use BK\Utils;

class Attachment extends Route {
    public $template = 'settings';
    public $public = false;

    /**
     * @var \Monolog\Logger
     */
    public $logger;
    public $record = 'attachment';
    public $short = 'ATCH';

    public function _get() {
        $this->assign('_type', $this->record);
        $this->assign('_short', $this->short);
    }

    public function _get_list() {
        $attachment = new \BK\Record\Attachment($this->app['db']);
        $this->setTemplate($this->record . '/list');
        $this->assign('list', $attachment->listAll());
    }

    public function _post_slide($id) {
        $attachment = new \BK\Record\Attachment($this->app['db']);
        $this->assign('attachments', $attachment->getAttachmentByType($this->params['attached_id'], $this->params['attached_type']));
        $this->setTemplate($this->record . '/slide');
    }

    public function _get_editor($id) {
        $this->assign('params', $this->params);
    }

    public function _post_editor($id) {
        $attachment = new \BK\Record\Attachment($this->app['db']);
        if (isset($this->params['base64'])) {
            $count = (int)$attachment->getCount($this->params['attached_id'], $this->params['attached_type']);
            $basedir = Utils::baseDir();
            $basedir = str_replace('src\classes\BK','',$basedir). 'public\\attachments\\';
            $ext = '.jpg'; // get the extension of the file
            $newname = strtoupper($this->params['attached_type']).($count + 1)."_".$this->params['name'].$ext;
            $target = $basedir.$newname;
            $data = $this->params['base64'];
            list($type, $data) = explode(';', $data);
            list($a, $data)      = explode(',', $data);
            $data = base64_decode($data);
            $result = file_put_contents($target, $data);
            if ($result) {
                $this->params['path'] = $target;
            }
        }
        $id = $attachment->save($this->params);
        $this->assign('id', $id);
    }

    public function _post_delete() {
        $attachment = new \BK\Record\Attachment($this->app['db']);
        $data = $attachment->load($this->params['id']);
        unlink($data['path']);
        $attachment->delete($this->params['id']);
        $this->setTemplate($this->record . '/editor');
    }
}
