<?php
namespace BK\Route;

use BK\Route;

class Bill extends Route {
    public $template = 'settings';
    public $public = false;

    /**
     * @var \Monolog\Logger
     */
    public $logger;
    public $record = 'bill';
    public $short = 'BILL';

    public function _get() {
        $this->assign('_type', $this->record);
        $this->assign('_short', $this->short);
    }

    public function _get_list() {
        $transaction = new \BK\Record\TransactionsOld($this->app['db']);
        $this->setTemplate($this->record . '/list');
        $list = $transaction->listWithRelated($this->short);
        foreach ($list as $index => $line) {
            $list[$index]['amount'] = ((float)$line['amount'] * -1);
        }
        $this->assign('list', $list);
    }

    public function _get_editor($id) {
        $customer = new \BK\Record\Customer($this->app['db']);
        $category = new \BK\Record\Category($this->app['db']);
        $project = new \BK\Record\Project($this->app['db']);
        $transaction = new \BK\Record\TransactionsOld($this->app['db']);
        $transactionLine = new \BK\Record\TransactionLine($this->app['db']);
        $invoice = $transaction->load($id);
        $invoice['lines'] = $transactionLine->listByTransactionId($id);
        foreach ($invoice['lines'] as $index => $line) {
            $invoice['lines'][$index]['amount'] = ((float)$line['amount'] * -1);
        }
        $this->setTemplate($this->record . '/editor');
        $this->assign('tns', $invoice);
        $this->assign('vendors', $customer->listByKey('id','name',' WHERE type = "vendor"'));
        $this->assign('customers', $customer->listByKey('id','name',' WHERE type = "customer"'));
        $this->assign('projects', $project->listByKey(['id','-','customer_id'],'name'));
        $this->assign('categories', $category->recordsByKey('id','name', $category->listByType('BILL')));
        $this->assign('related', $transaction->listByKey('id',['type','id'], 'WHERE type != "' . $this->short . '"'));
        $this->setTemplate($this->record . '/editor');
    }

    public function _post_editor($id) {
        $transaction = new \BK\Record\TransactionsOld($this->app['db']);
        $transactionLine = new \BK\Record\TransactionLine($this->app['db']);
        $this->params['type'] = $this->short;
        $id = $transaction->save($this->params);
        $lines = [];
        foreach ($this->params['deleteLines'] as $lineId) {
            $transactionLine->delete($lineId);
        }
        foreach ($this->params['lines'] as $line) {
            $line['transaction_id'] = $id;
            $line['amount'] = ((float)$line['amount'] * -1);
            $lines[] = $transactionLine->save($line);
        }
        $this->setTemplate($this->record . '/editor');
        $this->assign('id', $id);
        $this->assign('lines', $lines);
    }

    public function _post_delete() {
        $transaction = new \BK\Record\TransactionsOld($this->app['db']);
        $transactionLine = new \BK\Record\TransactionLine($this->app['db']);
        $transaction->delete($this->params['id']);
        $this->setTemplate($this->record . '/editor');
    }
}
