<?php
namespace BK\Route;

use BK\Route;

class Category extends Route {
    public $template = 'settings';
    public $public = false;

    /**
     * @var \Monolog\Logger
     */
    public $logger;


    public function _get_list() {
        $category = new \BK\Record\Category($this->app['db']);
        $this->setTemplate('category/list');
        $this->assign('list', $category->listActive());
    }
    public function _get_editor($id) {
        $category = new \BK\Record\Category($this->app['db']);
        $this->setTemplate('category/editor');
        $this->assign('category', $category->load($id));
    }
    public function _post_editor($id) {
        $category = new \BK\Record\Category($this->app['db']);
        $category->save($this->params);
        $this->setTemplate('category/editor');
    }
    public function _post_delete() {
        $category = new \BK\Record\Category($this->app['db']);
        $category->delete($this->params['id']);
        $this->setTemplate('category/editor');
    }
}
