<?php
namespace BK\Route;

use BK\Route;

class Customer extends Route {
    public $template = 'settings';
    public $public = false;

    /**
     * @var \Monolog\Logger
     */
    public $logger;

    public function _get() {
        $this->assign('_type','customer');
    }

    public function _get_list() {
        $customer = new \BK\Record\Customer($this->app['db']);
        $this->setTemplate('customer/list');
        $this->assign('list', $customer->listActive());
    }

    public function _get_editor($id) {
        $customer = new \BK\Record\Customer($this->app['db']);
        $vehicle = new \BK\Record\Vehicle($this->app['db']);
        $workOrder = new \BK\Record\Workorder($this->app['db']);
        $user = $customer->load($id);
        $this->setTemplate('customer/editor');
        $this->assign(['user','data'], $user);
        $this->assign('workorders', $workOrder->listAll(" AND e.id = ?",[$id]));
        $this->assign('vehicles', $vehicle->listAll(" AND v.entity_id = ?",[$id]));
    }

    public function _post_slide($id) {
        $this->_get_slide($id);
    }

    public function _get_slide($id) {
        $this->setTemplate('customer/slide');

    }

    public function _post_editor($id) {
        $customer = new \BK\Record\Customer($this->app['db']);
        $this->params['type'] = 'customer';
        $id = $customer->save($this->params);
        $this->assign('id', $id);
        $this->setTemplate('customer/editor');
    }

    public function _post_delete() {
        $customer = new \BK\Record\Customer($this->app['db']);
        $customer->delete($this->params['id']);
        $this->setTemplate('customer/editor');
    }
}
