<?php
namespace BK\Route;

use BK\Curzzler;
use BK\Record\Search;
use BK\Record\TransactionLine;
use BK\Route;

class Dashboard extends Route {
    public $template = 'dashboard';
    public $public = false;

    /**
     * @var \Monolog\Logger
     */
    public $logger;

    public function _get() {
        $invoice = new \BK\Record\Invoice($this->app['db']);
        $transaction = new \BK\Record\Transaction($this->app['db']);
        $time = [
            'start' => strtotime(date("m/01/Y")),
            'end' => strtotime(date("m/t/Y"))
        ];
        $this->assign('received', $transaction->getReceived($time['start'], $time['end']));
        $this->assign('invoiced', $transaction->getInvoiced($time['start'], $time['end']));
        $this->assign('balance', $transaction->getBalance($time['start'], $time['end']));
        $this->assign('open', $invoice->listAll("AND i.active = 1 ORDER BY created_on"));

    }

    public function _post_search() {
        $search = new Search($this->app['db']);
        $this->assign('results', $search->_global($this->params['search']));
    }
}
