<?php
namespace BK\Route;

use BK\Record\Entity;
use BK\Record\InvoiceLine;
use BK\Record\WorkorderLine;
use BK\Route;

class Invoice extends Route {
    public $template = 'settings';
    public $public = false;

    /**
     * @var \Monolog\Logger
     */
    public $logger;
    public $record = 'invoice';
    public $short = 'INV';

    public function _get() {
        $this->assign('_type', $this->record);
        $this->assign('_short', $this->short);
    }

    public function _get_list() {
        $invoice = new \BK\Record\Invoice($this->app['db']);
        $this->setTemplate($this->record . '/list');
        $this->assign('list', $invoice->listAll());
    }

    public function _get_editor($id) {
        $this->setTemplate($this->record . '/editor');
        $invoice = new \BK\Record\Invoice($this->app['db']);
        $invoiceLine = new \BK\Record\InvoiceLine($this->app['db']);
        $workorder = new \BK\Record\Workorder($this->app['db']);
        $entity = new Entity($this->app['db']);
        $vehicle = new \BK\Record\Vehicle($this->app['db']);
        $data = $invoice->load($id);
        $workorderData = $workorder->load($data['workorder_id']);
        $trans = new \BK\Record\Transaction($this->app['db']);
        if (isset($this->params['back_to_wo'])) {
            $data['back_to_wo'] = $this->params['back_to_wo'];
        }
        $data['lines'] = $invoiceLine->getByInvoice($id);
        $data['authorized_name'] = $workorderData['authorized_name'];
        $data['authorized_phone'] = $workorderData['authorized_phone'];
        $this->assign('data', $data);
        $this->assign('categories', \BK\Utils::workOrderCategories());
        $this->assign('trans', $trans->listAll());
        $this->assign('entity', $entity->load($workorderData['entity_id']));
        $this->assign('vehicle', $vehicle->load($workorderData['vehicle_id']));
    }

    public function _get_print($id) {
        $this->_get_editor($id);
        $setting = new \BK\Record\Setting($this->app['db']);
        $this->assign('header', $setting->get('business-header'));
        $this->setTemplate($this->record . '/print');
    }

    public function _get_convert($id) {
        $this->setTemplate($this->record . '/editor');
        $workorder = new \BK\Record\Workorder($this->app['db']);
        $workorderLine = new \BK\Record\WorkorderLine($this->app['db']);
        $entity = new Entity($this->app['db']);
        $vehicle = new \BK\Record\Vehicle($this->app['db']);
        $data = $workorder->load($id);
        $data['lines'] = $workorderLine->getByWorkOrder($id);
        foreach ($data['lines'] as $index => $line) {
            $data['lines'][$index]['cost_tran_id'] = null;
        }
        $data['workorder_id'] = $id;
        $data['back_to_wo'] = $id;
        $data['id'] = null;
        $data['_id'] = null;
        $this->assign('data', $data);
        $this->assign('categories', \BK\Utils::workOrderCategories());
        $this->assign('entity', $entity->load($data['entity_id']));
        $this->assign('vehicle', $vehicle->load($data['vehicle_id']));
    }


    public function _post_editor($id) {
        $this->setTemplate($this->record . '/editor');
        $invoice = new \BK\Record\Invoice($this->app['db']);
        $invoiceLine = new InvoiceLine($this->app['db']);
        $transaction = new \BK\Record\Transaction($this->app['db']);
        $id = $invoice->save($this->params);
        $lines = [];
        foreach ($this->params['deleteLines'] as $lineId) {
            $invoiceLine->delete($lineId);
        }
        foreach ($this->params['lines'] as $line) {
            $line['invoice_id'] = $id;
            $line['id'] = $invoiceLine->save($line);
            $update = false;
            if (trim($line['cost']) != '' && (float)$line['cost'] > 0) {
                $cost = [
                    'id' => 'new',
                    'entity_id' => $this->params['entity_id'],
                    'workorder_id' => $this->params['workorder_id'],
                    'invoice_id' => $id,
                    'invoice_line_id' => $line['id'],
                    'amount' => ((float) $line['cost']) * -1
                ];
                if (trim($line['cost_tran_id']) != '' && (float)$line['cost_tran_id'] > 0) {
                    $cost['id'] = $line['cost_tran_id'];
                }
                $update = true;
                $line['cost_tran_id'] = $transaction->save($cost);
            }
            if ($update) {
                $invoiceLine->save($line);
            }
            $lines[] = $line;
        }
        $this->assign('id', $id);
        $this->assign('lines', $lines);
        $workorder = new \BK\Record\Workorder($this->app['db']);
        $workorderData = $workorder->load($this->params['workorder_id']);
        $workorderData['invoice_id'] = $id;
        $workorder->save($workorderData);
    }

    public function _post_delete() {
        $invoice = new \BK\Record\Invoice($this->app['db']);
        $invoiceLine = new InvoiceLine($this->app['db']);
        $transaction = new \BK\Record\Transaction($this->app['db']);
        $data = $invoice->load($this->params['id']);
        $data['lines'] = $invoiceLine->getByInvoice($this->params['id']);
        foreach ($data['lines'] as $line) {
            if (trim($line['cost_tran_id']) == '' && (float)$line['cost_tran_id'] > 0) {
                $transaction->delete($line['cost_tran_id']);
            }
            $invoiceLine->delete($line['id']);
        }
        $invoice->delete($this->params['id']);
        $workorder = new \BK\Record\Workorder($this->app['db']);
        $workorderData = $workorder->load($data['workorder_id']);
        $workorderData['invoice_id'] = '';
        $workorder->save($workorderData);
        $this->setTemplate($this->record . '/editor');
    }
}
