<?php
namespace BK\Route;

use BK\Record\Attachment;
use BK\Route;
use BK\Utils;

class Payment extends Route {
    public $template = 'settings';
    public $public = false;

    /**
     * @var \Monolog\Logger
     */
    public $logger;
    public $record = 'payment';
    public $short = 'PYMT';

    public function _get() {
        $this->assign('_type', $this->record);
        $this->assign('_short', $this->short);
    }

    public function _get_list() {
        $transaction = new \BK\Record\TransactionsOld($this->app['db']);
        $transactionLine = new \BK\Record\TransactionLine($this->app['db']);
        $this->setTemplate($this->record . '/list');
        $this->assign('list', $transaction->listWithRelated($this->short));
    }

    public function _get_slide() {
        $this->assign('params', $this->params);
    }

    public function _post_slide($id) {
        $this->setTemplate($this->record . '/slide');
        $transaction = new \BK\Record\Transaction($this->app['db']);
        $this->assign('payments', $transaction->getPaymentsByWorkOrder($this->params['workorder_id']));
    }

    public function _get_editor($id) {
        $this->assign('params', $this->params);
    }

    public function _post_editor($id) {
        $transaction = new \BK\Record\Transaction($this->app['db']);
        $invoice = new \BK\Record\Invoice($this->app['db']);
        $id = $transaction->save($this->params);
        if ($invoice->isPaid($this->params['invoice_id'])) {
            $workorder = new \BK\Record\Workorder($this->app['db']);
            $inv = $invoice->get($this->params['invoice_id']);
            $wo = $workorder->get($inv['workorder_id']);
            $inv['active'] = 2;
            $wo['active'] = 2;
            $invoice->save($inv);
            $workorder->save($wo);
        }
        $this->assign('params', $this->params);
        $this->assign('id', $id);
    }
    public function _post_attachment($id) {
        $payment = new \BK\Record\Transaction($this->app['db']);
        $attachment = new Attachment($this->app['db']);
        $transactionId = $this->params['transaction_id'];
        $basedir = Utils::baseDir();
        $basedir = str_replace('src\classes\BK','',$basedir). 'public\\attachments\\';
        $ext = '.jpg'; // get the extension of the file
        $existingCount = $attachment->getCount($this->params['transaction_id'],'payment');
        $newname = "WO".$this->params['workorder_id']."_PYMNT_".($existingCount + 1).$ext;
        $target = $basedir.$newname;
        $data = $this->params['base64'];
        list($type, $data) = explode(';', $data);
        list(, $data)      = explode(',', $data);
        $data = base64_decode($data);
        $result = file_put_contents($target, $data);
        $id = false;
        if ($result) {
            $id = $attachment->save([
                'path' => $target,
                'name' => $newname,
                'attached_id' => $transactionId,
                'attached_type' => 'payment'
            ]);
            $payment->db->prepare("
                    UPDATE `transaction` SET attachment_id = ? 
                    WHERE id = ? ")
                ->execute([$id, $transactionId]);
        }
        $this->assign('_target', $target);
        $this->assign('_result', $result);
        $this->assign('params', $this->params);
        $this->assign('files', $_FILES);
        $this->assign('attachment_id', $id);
        $this->assign('_trans_id', $transactionId);
        $this->assign('id', $id);
    }

    public function _post_delete() {
        $payment = new \BK\Record\Transaction($this->app['db']);
        $attachment = new Attachment($this->app['db']);
        foreach ($attachment->getAttachmentByType($this->params['id'], 'payment') as $att) {
            $attachment->delete($att['id']);
        }
        $payment->delete($this->params['id']);
        $this->setTemplate($this->record . '/editor');
    }
}
