<?php
namespace BK\Route;

use BK\Record\TransactionLine;
use BK\Route;

class Project extends Route {
    public $template = 'settings';
    public $public = false;

    /**
     * @var \Monolog\Logger
     */
    public $logger;

    public function _get_list() {
        $project = new \BK\Record\Project($this->app['db']);
        $this->setTemplate('project/list');
        $this->assign('list', $project->listAll());
    }
    public function _get_editor($id) {
        $project = new \BK\Record\Project($this->app['db']);
        $customer = new \BK\Record\Customer($this->app['db']);
        $transaction = new \BK\Record\TransactionsOld($this->app['db']);
        $transactionLine = new TransactionLine($this->app['db']);
        $this->setTemplate('project/editor');
        $this->assign('project', $project->load($id));
        $this->assign('invoices', $transaction->listByType('INV',null, $id));
        $this->assign('bills', $transactionLine->listByProjectId($id, 'BILL'));
        $this->assign('customers', $customer->listByKey());
    }
    public function _post_editor($id) {
        $project = new \BK\Record\Project($this->app['db']);
        $project->save($this->params);
        $this->setTemplate('project/editor');
    }
    public function _post_delete() {
        $project = new \BK\Record\Project($this->app['db']);
        $project->delete($this->params['id']);
        $this->setTemplate('project/editor');
    }
}
