<?php
namespace BK\Route;

use BK\Route;

class Report extends Route {
    public $template = 'report';
    public $public = false;

    /**
     * @var \Monolog\Logger
     */
    public $logger;

    public function _get() {
        if (!isset($this->params['from']) || empty($this->params['from'])){
            $this->params['from'] = date("Y-m-01");
        }
        if (!isset($this->params['to']) || empty($this->params['to'])){
            $this->params['to'] = date("Y-m-t");
        }
        $time = [
            'start' => strtotime($this->params['from']),
            'end' => strtotime($this->params['to'])
        ];
        $transaction = new \BK\Record\Transaction($this->app['db']);
        $this->assign('received', $transaction->getReceived($time['start'], $time['end']));
        $this->assign('invoiced', $transaction->getInvoiced($time['start'], $time['end']));
        $this->assign('balance', $transaction->getBalance($time['start'], $time['end']));
        $this->assign('list', $transaction->reportList($time['start'], $time['end']));
    }
}
