<?php
namespace BK\Route;

use BK\Route;
use BK\Utils;
use http\Exception;

class Setting extends Route {
    public $template = 'settings';
    public $public = false;

    /**
     * @var \Monolog\Logger
     */
    public $logger;

    public function _get() {
        $setting = new \BK\Record\Setting($this->app['db']);
        $this->assign('themes', array_diff(scandir($this->app->_dir->base . '\public\css\theme'), array('..', '.')));
        $this->assign('businessHeader', $setting->get('business-header'));
    }

    public function _post_theme() {
        $setting = new \BK\Record\Setting($this->app['db']);
        $setting->set('theme', $this->params['theme']);
    }

    public function _post_update() {
        file_put_contents($this->app->_dir->base . '\src\session.json', json_encode([]));
        $this->assign('session', true);
    }

    public function _post_set() {
        if (!isset($this->params['field']) || !isset($this->params['value']) || (isset($this->params['field']) && trim($this->params['field']) == '')) {
            throw new \Exception('Unable to set setting');
        }
        $setting = new \BK\Record\Setting($this->app['db']);
        $setting->set($this->params['field'], $this->params['value']);
    }



    public function _post_install() {
        $installPath = str_replace('\www','',$this->app->_dir->base);
        $installFile = $installPath . '\Update.zip';
        file_put_contents($installFile, file_get_contents('https://bookkeeper.appstash.in/Update.zip'));
        $zip = new \ZipArchive();
        $res = $zip->open($installFile);
        if ($res === TRUE) {
            $zip->extractTo($installPath . '\\www\\');
            $zip->close();
            Utils::removeDirectory($installPath . '\www\__MACOSX');
            unlink($installFile);
            $this->assign('install', true);
        } else {
            $this->assign('install', false);
        }
    }
}
