<?php
namespace BK\Route;

use BK\Route;

class Vehicle extends Route {
    public $template = 'settings';
    public $public = false;

    /**
     * @var \Monolog\Logger
     */
    public $logger;

    public function _get() {
        $this->assign('_type','vehicle');
    }

    public function _get_list() {
        $vehicle = new \BK\Record\Vehicle($this->app['db']);
        $this->setTemplate('vehicle/list');
        $this->assign('list', $vehicle->listAll());
    }

    public function _get_editor($id) {
        $vehicle = new \BK\Record\Vehicle($this->app['db']);
        $workOrder = new \BK\Record\Workorder($this->app['db']);
        $this->setTemplate('vehicle/editor');
        $this->assign('data', $vehicle->load($id));
        $this->assign('workorders', $workOrder->listAll(" AND wo.vehicle_id = ?",[$id]));
    }

    public function _post_slide($id) {
        $this->_get_slide($id);
    }

    public function _get_slide($id) {
        $this->setTemplate('vehicle/slide');

    }

    public function _post_editor($id) {
        $vehicle = new \BK\Record\Vehicle($this->app['db']);
        $id = $vehicle->save($this->params);
        $this->assign('id', $id);
        $this->setTemplate('vehicle/editor');
    }

    public function _post_delete() {
        $vehicle = new \BK\Record\Vehicle($this->app['db']);
        $vehicle->delete($this->params['id']);
        $this->setTemplate('vehicle/editor');
    }
}
