<?php
namespace BK\Route;

use BK\Route;

class Vendor extends Route {
    public $template = 'settings';
    public $public = false;

    /**
     * @var \Monolog\Logger
     */
    public $logger;

    public function _get() {
        $this->assign('_type','vendor');
    }

    public function _get_list() {
        $customer = new \BK\Record\Customer($this->app['db']);
        $this->setTemplate('customer/list');
        $this->setTitle('Vendor List');
        $this->assign('list', $customer->listByType('vendor'));
    }

    public function _get_editor($id) {
        $customer = new \BK\Record\Customer($this->app['db']);
        $project = new \BK\Record\Project($this->app['db']);
        $transaction = new \BK\Record\TransactionsOld($this->app['db']);
        $this->setTemplate('customer/editor');
        $this->setTitle('Vendor Editor');
        $this->assign('user', $customer->load($id));
        $this->assign('invoices', $transaction->listByCustomer($id, 'INV'));
        $this->assign('payments', $transaction->listByCustomer($id, 'PAY'));
        $this->assign('projects', $project->listByCustomer($id, 'PAY'));
    }

    public function _post_editor($id) {
        $customer = new \BK\Record\Customer($this->app['db']);
        $this->params['type'] = 'vendor';
        $customer->save($this->params);
        $this->setTemplate('customer/editor');
    }

    public function _post_delete() {
        $customer = new \BK\Record\Customer($this->app['db']);
        $customer->delete($this->params['id']);
        $this->setTemplate('customer/editor');
    }
}
