<?php
namespace BK\Route;

use BK\Record\InvoiceLine;
use BK\Record\Vehicle;
use BK\Record\WorkorderLine;
use BK\Route;

class Workorder extends Route {
    public $template = 'workorder';
    public $public = false;

    /**
     * @var \Monolog\Logger
     */
    public $logger;
    public $record = 'workorder';
    public $short = 'WO';

    public function _get() {
        $this->assign('_type', $this->record);
        $this->assign('_short', $this->short);
    }

    public function _get_list() {
        $this->setTemplate($this->record . '/list');
        $workorder = new \BK\Record\Workorder($this->app['db']);
        $this->assign('list', $workorder->listAll());
    }

    public function _get_editor($id) {
        $attachments = new \BK\Record\Attachment($this->app['db']);
        $transaction = new \BK\Record\Transaction($this->app['db']);
        $customer = new \BK\Record\Customer($this->app['db']);
        $vehicle = new Vehicle($this->app['db']);
        $workorder = new \BK\Record\Workorder($this->app['db']);
        $workorderLine = new WorkorderLine($this->app['db']);
        $invoice = new \BK\Record\Invoice($this->app['db']);
        $invoiceLine = new InvoiceLine($this->app['db']);
        $data = $workorder->load($id);
        $data['lines'] = $workorderLine->getByWorkOrder($id);
        if (empty($data['invoice_id'])) {
            $inv = $invoice->getByWorkOrder($id);
            $data['invoice_id'] = (!empty($inv) ? $inv['id'] : null);
        }
        $this->setTemplate($this->record . '/editor');
        $this->assign('data', $data);
        $this->assign('totals', [
            'workorder_cost' => $workorderLine->getTotalDueByWorkOrder($id),
            'workorder_paid' => $workorder->getTotalPaidByWorkOrder($id),
            'invoice_cost' => $invoiceLine->getTotalByWorkOrder($id)
        ]);
        $this->assign('payments', $transaction->getPaymentsByWorkOrder($id));
        $this->assign('attachments', $attachments->listAll());

        $this->assign('categories', \BK\Utils::workOrderCategories());
        $this->assign('customers',$customer->listByKey());
        $this->assign('vehicles',$vehicle->listByKey(['id','-','entity_id'],'name'));
    }

    public function _post_editor($id) {
        $this->setTemplate($this->record . '/editor');
        $workorder = new \BK\Record\Workorder($this->app['db']);
        $workorderLine = new WorkorderLine($this->app['db']);
        $invoice = new \BK\Record\Invoice($this->app['db']);
        $transaction = new \BK\Record\Transaction($this->app['db']);
        if (isset($this->params['received_on']) && trim($this->params['received_on']) != '') {
            $this->params['received_on'] = strtotime($this->params['received_on']);
        }
        if (isset($this->params['promised_on']) && trim($this->params['promised_on']) != '') {
            $this->params['promised_on'] = strtotime($this->params['promised_on']);
        }
        if (empty($data['invoice_id'])) {
            $inv = $invoice->getByWorkOrder($id);
            $this->params['invoice_id'] = (!empty($inv) ? $inv['id'] : null);
        }
        $id = $workorder->save($this->params);
        $lines = [];
        foreach ($this->params['deleteLines'] as $lineId) {
            $workorderLine->delete($lineId);
        }
        foreach ($this->params['lines'] as $line) {
            $line['workorder_id'] = $id;
            $line['id'] = $workorderLine->save($line);
            $update = false;
            if (isset($line['cost']) && trim($line['cost']) != '' && (float)$line['cost'] > 0) {
                $cost = [
                    'id' => 'new',
                    'entity_id' => $this->params['entity_id'],
                    'workorder_id' => $id,
                    'workorder_line_id' => $line['id'],
                    'amount' => ((float) $line['cost']) * -1
                ];
                if (trim($line['cost_tran_id']) != '' && (float)$line['cost_tran_id'] > 0) {
                    $cost['id'] = $line['cost_tran_id'];
                }
                $update = true;
                $line['cost_tran_id'] = $transaction->save($cost);
            }
            if (isset($line['paid']) && trim($line['paid']) != '' && (float)$line['paid'] > 0) {
                $paid = [
                    'id' => 'new',
                    'entity_id' => $this->params['entity_id'],
                    'workorder_id' => $id,
                    'workorder_line_id' => $line['id'],
                    'amount' => (float) $line['paid']
                ];
                if (trim($line['paid_tran_id']) != '' && (float)$line['paid_tran_id'] > 0) {
                    $paid['id'] = $line['paid_tran_id'];
                }
                $update = true;
                $line['paid_tran_id'] = $transaction->save($paid);
            }
            if ($update) {
                $workorderLine->save($line);
            }
            $lines[] = $line;
        }
        $this->assign('id', $id);
        $this->assign('lines', $lines);
    }

    public function _post_delete() {
        $workorder = new \BK\Record\Workorder($this->app['db']);
        $workorderLine = new WorkorderLine($this->app['db']);
        $transaction = new \BK\Record\Transaction($this->app['db']);
        $data = $workorder->load($this->params['id']);
        $data['lines'] = $workorderLine->getByWorkOrder($this->params['id']);
        foreach ($data['lines'] as $line) {
            if (trim($line['cost_tran_id']) == '' && (float)$line['cost_tran_id'] > 0) {
                $transaction->delete($line['cost_tran_id']);
            }
            if (trim($line['paid_tran_id']) == '' && (float)$line['paid_tran_id'] > 0) {
                $transaction->delete($line['paid_tran_id']);
            }
            $workorderLine->delete($line['id']);
        }
        $workorder->delete($this->params['id']);
        $this->setTemplate($this->record . '/editor');
    }
}
