<?php
namespace BK;

class Utils {
    static $emailFrom = 'bookkeeper@appstash.in';
    static $appName = 'BookKeeper';

    static function clientIp(){
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            $ip = $_SERVER['REMOTE_ADDR'];
        }
        return $ip;
    }

    static function workOrderCategories() {
        return [
            1 => 'Labor Only',
            2 => 'Parts',
            3 => 'Accessories',
            4 => 'Gas, Oil, Grease',
            5 => 'Misc',
            6 => 'Sublet Repairs',
            7 => 'Tax'
        ];
    }

    static function mail($subject, $content, $to){
        $headers = "From: " . self::$emailFrom . "\r\n";
        $headers .= "Reply-To: " . self::$emailFrom . "\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
        return mail($to, self::$appName . '::' . $subject, $content, $headers);
    }

    static function censorContacts($contacts) {
        foreach ($contacts as $index => $contact) {
            if (stripos($contact, '@') !== false) {
                $contacts[$index] = self::censorEmail($contact);
            }
            if (strlen(preg_replace('/[^0-9]/', '', $contact)) == 10) {
                $contacts[$index] = self::censorPhone($contact);
            }
        }
        return $contacts;
    }

    static function formatPhoneNumber($phoneNumber) {
        $phoneNumber = preg_replace('/[^0-9]/','',$phoneNumber);
        if(strlen($phoneNumber) > 10) {
            $countryCode = substr($phoneNumber, 0, strlen($phoneNumber)-10);
            $areaCode = substr($phoneNumber, -10, 3);
            $nextThree = substr($phoneNumber, -7, 3);
            $lastFour = substr($phoneNumber, -4, 4);
            $phoneNumber = '+'.$countryCode.' ('.$areaCode.') '.$nextThree.'-'.$lastFour;
        } else if(strlen($phoneNumber) == 10) {
            $areaCode = substr($phoneNumber, 0, 3);
            $nextThree = substr($phoneNumber, 3, 3);
            $lastFour = substr($phoneNumber, 6, 4);
            $phoneNumber = '('.$areaCode.') '.$nextThree.'-'.$lastFour;
        } else if(strlen($phoneNumber) == 7) {
            $nextThree = substr($phoneNumber, 0, 3);
            $lastFour = substr($phoneNumber, 3, 4);
            $phoneNumber = $nextThree.'-'.$lastFour;
        }

        return $phoneNumber;
    }

    static function censorPhone($phone) {
        $phone = self::formatPhoneNumber($phone);
        $first = substr($phone,0,4);
        $last = substr($phone,-3);
        return $first . (str_repeat('*',strlen($phone)-(strlen($first)+strlen($last)))) . $last;
    }

    static function censorEmail($email) {
        list($name, $domain) = explode('@', $email);
        $namePart = substr($name,0,2);
        $domainPart = substr($domain,-7);
        return $namePart . (str_repeat('*',strlen($name)-strlen($namePart)))
            . '@' . (str_repeat('*',strlen($domain)-strlen($domainPart))) . $domainPart;
    }

    static function mail_attachment($subject, $message, $mailto, $files) {
        $senderMail = self::$emailFrom;
        $from = self::$appName . " <" . self::$emailFrom . ">";
        $headers = "From: $from";

        // boundary
        $semi_rand = md5(time());
        $mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";

        // headers for attachment
        $headers .= "\nMIME-Version: 1.0\n" . "Content-Type: multipart/mixed;\n" . " boundary=\"{$mime_boundary}\"";

        // multipart boundary
        $message = "--{$mime_boundary}\n" . "Content-Type: text/html; charset=\"UTF-8\"\n" .
            "Content-Transfer-Encoding: 7bit\n\n" . $message . "\n\n";

        // preparing attachments
        if(count($files) > 0){
            for($i=0; $i<count($files); $i++){
                if(is_file($files[$i])){
                    $filesize = filesize($files[$i]);
                    $filename = str_replace('.log','.txt', basename($files[$i]));
                    $message .= "--{$mime_boundary}\n";
                    $fp =    fopen($files[$i],"rb");
                    $data =  fread($fp, $filesize);
                    fclose($fp);
                    $data = chunk_split(base64_encode($data));
                    $message .= "Content-Type: application/octet-stream; name=\"".$filename."\"\n" .
                        "Content-Description: ".$filename."\n" .
                        "Content-Disposition: attachment;\n" . " filename=\"".$filename."\"; size=".$filesize.";\n" .
                        "Content-Transfer-Encoding: base64\n\n" . $data . "\n\n";
                }
            }
        }

        $message .= "--{$mime_boundary}--";
        $returnpath = "-f" . $senderMail;
        $result = mail($mailto, self::$appName . '::' . $subject, $message, $headers, $returnpath);
        return $result;
    }

    static function defaultTimeZone() {
        $tz = 'UTC';
        if (isset($_SERVER['timezone']) && $_SERVER['timezone'] != 'UTC') {
            $tz = $_SERVER['timezone'];
        }
        if (isset($_SESSION['timezone']) && $_SESSION['timezone'] != 'UTC') {
            $tz = $_SESSION['timezone'];
        }
        return $tz;
    }

    static function dashToCamel($string, $lcfirst = false) {
        $string = str_replace(' ', '', ucwords(
            str_replace('-', ' ', $string)
        ));
        if ($lcfirst) {
            $string = lcfirst($string);
        }
        return $string;
    }

    static function uuidv4() {
        return implode('-', [
            bin2hex(random_bytes(4)),
            bin2hex(random_bytes(2)),
            bin2hex(chr((ord(random_bytes(1)) & 0x0F) | 0x40)) . bin2hex(random_bytes(1)),
            bin2hex(chr((ord(random_bytes(1)) & 0x3F) | 0x80)) . bin2hex(random_bytes(1)),
            bin2hex(random_bytes(6))
        ]);
    }

    static function generateRandomString($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    static function baseDir() {
        return str_replace(['/src','/classes','/BK','/PDO','/Record','/REST','/Route'], [''],  __DIR__);
    }

    static function redirect($url, $status = 302) {
        if (stripos($url, 'http') === false) {
            header("Location: {$_SERVER['REQUEST_SCHEME']}://{$_SERVER['SERVER_NAME']}{$url}");
        } else {
            header("Location: {$url}");
        }
        exit;
    }

    static function removeDirectory($path) {
        if (!file_exists($path)) {
            return true;
        }

        if (!is_dir($path)) {
            return unlink($path);
        }

        foreach (scandir($path) as $item) {
            if ($item == '.' || $item == '..') {
                continue;
            }

            if (!self::removeDirectory($path . DIRECTORY_SEPARATOR . $item)) {
                return false;
            }

        }

        return rmdir($path);
    }
}