<?php
/**
 *  Work around for allowing PHP to serve pages
 *  along with being forked.
 */

if (php_sapi_name() !== 'cli') {
    throw new Exception('Must be initiated from CLI');
}
if (empty($argv[1])) {
    throw new Exception('JSON must be passed as an argument');
}

$basedir = str_replace(['/src/scripts'],[''],dirname(__FILE__));
include("{$basedir}/vendor/autoload.php");

$arguments = json_decode($argv[1], true);
try {
    $classname = (string)$arguments['class'];
    $class = new $classname($arguments['const']);
    $method = (string)$arguments['method'];
    $class->$method($arguments['params']);
} catch (Exception $e) {
    $name = (isset($arguments['name']) ? $arguments['name'] : "$classname/$method");
    throw $e;
}