<?php
$base = str_replace("\public","", $_SERVER['DOCUMENT_ROOT']);
error_reporting(E_ALL);
putenv("TMP=".$base."\cache");
putenv("TEMP=".$base."\cache");
putenv("TMPDIR=".$base."\cache");
putenv("MAGICK_TEMPORARY_PATH=".$base."\cache");
putenv("MAGICK_TMPDIR=".$base."\cache");
putenv("MAGICK_TMP=".$base."\cache");
putenv("MAGICK_TEMP=".$base."\cache");
putenv("IMAGICK_TEMPORARY_PATH=".$base."\cache");
putenv("IMAGICK_TMPDIR=".$base."\cache");
putenv("IMAGICK_TMP=".$base."\cache");
putenv("IMAGICK_TEMP=".$base."\cache");
ini_set('session.save_path', $base."\cache");
ini_set('upload_tmp_dir', $base."\cache");
ini_set('sys_temp_dir', $base."\cache");
ini_set('display_errors', 'On');
ini_set('memory_limit', '256M');
session_start();

if ($_SERVER['REQUEST_METHOD'] == 'POST' && empty($_POST)) {
    $_POST = json_decode(file_get_contents("php://input"), true);
    $_REQUEST = json_decode(file_get_contents("php://input"), true);
}
$config['displayErrorDetails'] = true;
$config['addContentLengthHeader'] = false;
$app = new \Slim\App(['settings' => $config]);

// Fetch DI Container
$container = $app->getContainer();
$container['_env'] = (isset($_SERVER['ENVIRONMENT']) ? $_SERVER['ENVIRONMENT'] : 'development');
$container['_dir'] = (object)[
    'base' => $base
];

$container['_uri'] = (object)[
    'request' => '/',
    'method' => strtolower($_SERVER['REQUEST_METHOD']),
    'route' => isset($_REQUEST['_route']) ? $_REQUEST['_route'] : '',
    'action' => isset($_REQUEST['_action']) ? $_REQUEST['_action'] : '',
    'id' => isset($_REQUEST['_id']) ? $_REQUEST['_id'] : ''
];
$sessionFile = str_replace('\public','',$container['_dir']->base) . '\src\session.json';
if (!file_exists($sessionFile)) {
    $_SESSION['_setup'] = false;
    $_SESSION['_version'] = [];
} else {
    $_SESSION = json_decode(file_get_contents($sessionFile),true);
}

$container['logger'] = function($c) {
    $logger = new \Monolog\Logger('sys_logger');
    $file_handler = new \Monolog\Handler\StreamHandler('../logs/' . date('Y-m-d') . '.log');
    $logger->pushHandler($file_handler);
    return $logger;
};

$container['db'] = function ($c) {
    $dns = ['database'=>'bookkeeper'];
    $database = str_replace('\public','',$c['_dir']->base) . '\src\bookkeeper.db';
    $setup = str_replace('\public','',$c['_dir']->base) . '\src\install.sqlite';
    if (!file_exists($database)) {
        $_SESSION['_setup'] = true;
        file_put_contents($database,'');
    }
    $pdo = new \PDO('sqlite:' . $database);
    if ($pdo === null) {
        throw new Exception("Unable to connect to database!");
    }
    $db = new \BK\PDO\SQLite($pdo);
    if (isset($_SESSION['_setup']) && $_SESSION['_setup']) {
        $sqls = file_get_contents($setup);
        foreach (explode(';',$sqls) as $sql) {
            $db->prepare(trim($sql))->execute([]);
        }
        unset($_SESSION['_setup']);
    }
    $db->dns = $dns;
    return $db;
};
// Register Twig View helper
$container['view'] = function ($con) {
    $view = new \Slim\Views\Twig('../templates', [
    ]);
    // Instantiate and add Slim specific extension
    $basePath = rtrim(str_ireplace('index.php', '', $con['request']->getUri()->getBasePath()), '/');
    $view->addExtension(new Slim\Views\TwigExtension($con['router'], $basePath));

    $view->getEnvironment()->enableAutoReload();
    // Add in slim functions
    $view->getEnvironment()->addFunction(new Twig\TwigFunction('cssName', function($data){
        return ucwords(str_ireplace(['.css','-'],['',' '],$data));
    }));
    $view->getEnvironment()->addFunction(new Twig\TwigFunction('date_diff', function($date, $from = null){
        $from = strtotime(($from ? $from : "now"));
        $date = strtotime($date);
        return number_format(($from - $date), 0, '.', ',') . ' seconds';
    }));
    $view->getEnvironment()->addFunction(new Twig\TwigFunction('href', function($string){
        $parts = explode("/",$string);
        $url = "index.php";
        $join = [];
        if (isset($parts[0]) && $parts[0] != '') {
            $join[] = "_route=".$parts[0];
        }
        if (isset($parts[1]) && $parts[1] != '') {
            $join[] = "_action=".$parts[1];
        }
        if (isset($parts[2]) && $parts[2] != '') {
            $join[] = "_id=".$parts[2];
        }
        return new \Twig\Markup($url . (!empty($join) ? "?" . implode("&", $join) : ""),'UTF-8');
    }));
    $view->getEnvironment()->addFunction(new Twig\TwigFunction('loading', function(){
        return new \Twig\Markup('<div class="lds-ring"><div></div><div></div><div></div><div></div></div>','UTF-8');
    }));
    $view->getEnvironment()->addFunction(new Twig\TwigFunction('pre', function($data){
        echo '<pre>';
        print_r($data);
        echo '</pre>';
    }));
    $view->getEnvironment()->addFunction(new Twig\TwigFunction('vardump', function($var) {
        ob_start();
        var_dump($var);
        $result = ob_get_clean();
        return new \Twig\Markup($result,'UTF-8');
    }));
    $view->getEnvironment()->addFunction(new Twig\TwigFunction('time', function($data){
        echo number_format((float)$data, 4, '.', '');
    }));
    $view->getEnvironment()->addFunction(new Twig\TwigFunction('redirect', function(){
        echo "<input name='redirect' id='redirect' value='' class='hidden'>";
        echo "<script>document.getElementById('redirect').setAttribute('value', document.URL);</script>";
    }));
    $view->getEnvironment()->addFunction(new Twig\TwigFunction('trimit', function($string, $characters = 50){
        $characters = (int) $characters;
        return strlen($string) > $characters ? substr($string, 0, $characters) . " ..." : $string;
    }));
    $view->getEnvironment()->addFunction(new Twig\TwigFunction('get_contents', function($file){
        echo file_get_contents($file);
    }));
    $view->getEnvironment()->addFunction(new Twig\TwigFunction('jsond', function($json) {
        return json_decode($json, true);
    }));
    $view->getEnvironment()->addFunction(new Twig\TwigFunction('jsone', function($array) {
        return json_encode($array);
    }));
    $view->getEnvironment()->addFunction(new Twig\TwigFunction('simpleArray', function($array, $key) {
        $simple = [];
        foreach ($array as $row) {
            $simple[] = $row[$key];
        }
        return $simple;
    }));
    $view->getEnvironment()->addFunction(new Twig\TwigFunction('typeSelect', function($id, $value, $options, $label = null, $new = null) {
        if (strpos($id, '=') === false) {
            $id = 'id="'.$id.'"';
        }
        $html = '<div class="select-type-ahead mb-3" data-id="'.$id.'">';
        if ($label) {
            $html .= '<label for="'.$id.'">'.$label.'</label>';
        }
        $textOptions = [];
        foreach ($options as $optid => $text) {
            if (strpos($optid, '-')) {
                $parts = explode('-', $optid);
                $dataValue = $parts[0];
            } else {
                $dataValue = $optid;
            }
            $textOptions[$dataValue] = $text;
        }
        $html .= '<div class="select-type-ahead-wrapper">';
        $html .= '<div class="input-group mb-3">';
        $html .= '<input type="text" class="form-control" value="'.(isset($textOptions[$value]) ? $textOptions[$value] : '').'">';
        $html .= '<input '.$id.' class="select-type-ahead-value" type="text" value="'.$value.'">';
        $html .= '<div class="input-group-append"><button class="btn btn-outline-secondary dropdown-toggle" type="button"></button></div>';
        if ($new) {
            $html .= '<div class="input-group-append"><button ';
            if (stripos($new,'#') !== false) {
                $html .= 'id="' . str_replace('#','',$new) . '" ';
            }
            $html .= 'class="';
            if (stripos($new,'.') !== false) {
                $html .= str_replace('.','',$new);
            }
            $html .= ' btn btn-outline-primary" type="button"><i class="fas fa-plus"></i></button></div>';
        }
        $html .= '</div>';
        $html .= '<ul class="list-group">';
        foreach ($options as $optid => $text) {
            $secondaryOptId = '';
            if (strpos($optid,'-')) {
                $parts = explode('-',$optid);
                $dataValue = $parts[0];
                $secondaryOptId = ' data-filter="'.$parts[1].'"';
            } else {
                $dataValue = $optid;
            }
            $html .= '<li class="list-group-item list-group-item-action '.($dataValue.'' == $value.'' ? 'bg-dark text-white' : '').'" data-value="'.$dataValue.'"' . $secondaryOptId . '>'.$text.'</li>';
        }
        if (count($options) == 0) {
            $html .= '<li class="list-group-item list-group-item-action disabled" data-value="">Empty</li>';
        }
        $html .= '</ul></div></div>';
        return new \Twig\Markup($html,'UTF-8');
    }));
    $view->getEnvironment()->addFunction(new Twig\TwigFunction('summarizeArray', function($array, $show = 1, $separator = '>') {
        $limit = count($array) - 2;
        $endKey = count($array) - 1;
        $parts = [];
        $string = $array[0];
        if (count($array) > 1) {
            $string .= $separator;
        }
        if ($show < $limit) {
            $string .= " ... {$separator}";
        } else {
            $show = count($array);
        }
        for ($i=0; $i<$show; $i++) {
            $key = $endKey - $i;
            if ($key == 0) { continue; }
            $parts[] = $array[$key];
        }
        $parts = array_reverse($parts);
        $string .= implode($separator, $parts);
        return new \Twig\Markup($string,'UTF-8');
    }));
    $view->getEnvironment()->addFunction(new Twig\TwigFunction('toText', function($object, $key) {
        echo json_encode($object);
    }));
    return $view;
};

$_SESSION['_version']['current'] = [
    'number' => file_get_contents($container['_dir']->base . '\src\version'),
    'time' => time()
];
if (!isset($_SESSION['_version']['remote'])
    || (isset($_SESSION['_version']['remote']) && time() - $_SESSION['_version']['remote']['time'] > 86400)
    || (isset($_SESSION['_version']['remote']) && !$_SESSION['_version']['remote']['number'])) {
    $_SESSION['_version']['remote'] = [
        'number' => @file_get_contents("https://bookkeeper.appstash.in/www/src/version"),
        'time' => time()
    ];
}
file_put_contents($sessionFile, json_encode($_SESSION));

